/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.nusmv.smv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LTLUnaryOperator implements Enumerator
{
    NEXT_STATE(0, "NextState", "X"),
    GLOBALLY(1, "Globally", "G"),
    FINALLY(2, "Finally", "F"),
    PREVIOUS_STATE(3, "PreviousState", "Y"),
    NOT_PREVIOUS_STATE(4, "NotPreviousState", "Z"),
    HISTORICALLY(5, "Historically", "H"),
    ONCE(6, "Once", "O");

    public static final int NEXT_STATE_VALUE = 0;
    public static final int GLOBALLY_VALUE = 1;
    public static final int FINALLY_VALUE = 2;
    public static final int PREVIOUS_STATE_VALUE = 3;
    public static final int NOT_PREVIOUS_STATE_VALUE = 4;
    public static final int HISTORICALLY_VALUE = 5;
    public static final int ONCE_VALUE = 6;
    private static final LTLUnaryOperator[] VALUES_ARRAY;
    public static final List<LTLUnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LTLUnaryOperator[]{NEXT_STATE, GLOBALLY, FINALLY, PREVIOUS_STATE, NOT_PREVIOUS_STATE, HISTORICALLY, ONCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LTLUnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LTLUnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LTLUnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return NEXT_STATE;
            }
            case 1: {
                return GLOBALLY;
            }
            case 2: {
                return FINALLY;
            }
            case 3: {
                return PREVIOUS_STATE;
            }
            case 4: {
                return NOT_PREVIOUS_STATE;
            }
            case 5: {
                return HISTORICALLY;
            }
            case 6: {
                return ONCE;
            }
        }
        return null;
    }

    private LTLUnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

