/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.nusmv.smv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CTLUnaryOperator implements Enumerator
{
    EXIST_GLOBALLY(0, "ExistGlobally", "EG"),
    EXIST_NEXT_STATE(1, "ExistNextState", "EX"),
    EXIST_FINALLY(2, "ExistFinally", "EF"),
    FOR_ALL_GLOBALLY(3, "ForAllGlobally", "AG"),
    FOR_ALL_NEXT_STATE(4, "ForAllNextState", "AX"),
    FOR_ALL_FINALLY(5, "ForAllFinally", "AF");

    public static final int EXIST_GLOBALLY_VALUE = 0;
    public static final int EXIST_NEXT_STATE_VALUE = 1;
    public static final int EXIST_FINALLY_VALUE = 2;
    public static final int FOR_ALL_GLOBALLY_VALUE = 3;
    public static final int FOR_ALL_NEXT_STATE_VALUE = 4;
    public static final int FOR_ALL_FINALLY_VALUE = 5;
    private static final CTLUnaryOperator[] VALUES_ARRAY;
    public static final List<CTLUnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CTLUnaryOperator[]{EXIST_GLOBALLY, EXIST_NEXT_STATE, EXIST_FINALLY, FOR_ALL_GLOBALLY, FOR_ALL_NEXT_STATE, FOR_ALL_FINALLY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CTLUnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CTLUnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CTLUnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CTLUnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return EXIST_GLOBALLY;
            }
            case 1: {
                return EXIST_NEXT_STATE;
            }
            case 2: {
                return EXIST_FINALLY;
            }
            case 3: {
                return FOR_ALL_GLOBALLY;
            }
            case 4: {
                return FOR_ALL_NEXT_STATE;
            }
            case 5: {
                return FOR_ALL_FINALLY;
            }
        }
        return null;
    }

    private CTLUnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

