/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.Messages;

public class ShortcutDiagramParser
implements IParser {
    public String getEditString(IAdaptable element, int flags) {
        Diagram diagram = this.doAdapt(element);
        if (diagram == null || diagram.eResource() == null) {
            return Messages.DiagramNotFound;
        }
        return diagram.getName();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        Diagram diagram = this.doAdapt(element);
        if (diagram == null || diagram.eResource() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, Messages.SetNameDiagram);
        SetRequest request = new SetRequest((EObject)diagram, (EStructuralFeature)NotationPackage.eINSTANCE.getDiagram_Name(), (Object)newString);
        command.compose((IUndoableOperation)new SetValueCommand(request));
        return command;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Diagram diagram = this.doAdapt(element);
        if (diagram == null || diagram.eResource() == null) {
            return Messages.DiagramNotFound;
        }
        return diagram.getName();
    }

    public boolean isAffectingEvent(Object event, int flags) {
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    protected Diagram doAdapt(IAdaptable element) {
        EObject obj = EMFHelper.getEObject((Object)element);
        if (obj instanceof Diagram) {
            return (Diagram)obj;
        }
        return null;
    }
}

