/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.ui;

import java.util.ArrayList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfigurationURLSelectionDialog
extends Dialog {
    private static final int SIZE_WIDTH = 400;
    private static final int SIZE_HEIGHT = 300;
    private static final String MSG_TITLE = "Select the URI of the configuration model";
    private static final Object TREE_ROOT = new Object();
    private Resource selection;

    public ConfigurationURLSelectionDialog(Shell parentShell, int style) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        inner.setLayout((Layout)new FillLayout());
        ListViewer list = new ListViewer(inner, 2816);
        list.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        list.setContentProvider((IContentProvider)new ModelContentProvider());
        list.setInput(TREE_ROOT);
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object first = s.getFirstElement();
                if (first == null) {
                    ConfigurationURLSelectionDialog.this.onSelection(null);
                } else if (first instanceof Resource) {
                    ConfigurationURLSelectionDialog.this.onSelection((Resource)first);
                } else {
                    ConfigurationURLSelectionDialog.this.onSelection(null);
                }
            }
        });
        ConfigurationURLSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control composite = super.createButtonBar(parent);
        if (this.selection == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
        return composite;
    }

    private void onSelection(Resource element) {
        this.selection = element;
        if (this.selection == null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(400, 300);
        Point size = shell.getParent().getShell().getSize();
        shell.setLocation((size.x - 400) / 2, (size.y - 300) / 2);
        shell.setText(MSG_TITLE);
    }

    private ILabelProvider getLabelProvider() {
        return new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Resource res = (Resource)element;
                return res.getURI().toString();
            }
        };
    }

    private static class ModelContentProvider
    implements IStructuredContentProvider {
        private ModelContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList data = new ArrayList();
            return data.toArray();
        }
    }
}

