/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.monitoringxml.popup.actions;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.StringBufferLog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.osgi.framework.Bundle;
import org.polarsys.chess.monitoring.monitoringxml.MonitoringxmlPackage;
import org.polarsys.chess.monitoring.monitoringxml.util.MonitoringxmlResourceFactoryImpl;

public class LaunchBackpropagation
implements IObjectActionDelegate {
    private Shell shell;
    private IFile xmlFile;
    private IFile chessFile;
    private IWorkspaceRoot root;
    private static String XML_MODEL_PATH;
    private static Resource XML_MODEL_RESOURCE;
    private static String UML_MODEL_PATH;
    private static Resource UML_MODEL_RESOURCE;

    public LaunchBackpropagation() {
    }

    public LaunchBackpropagation(Shell inShell, IFile inXMLFile, IFile inCHESSFile, IWorkspaceRoot inRoot) {
        this.shell = inShell;
        this.xmlFile = inXMLFile;
        this.chessFile = inCHESSFile;
        this.root = inRoot;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        ISelectionService service = targetPart.getSite().getWorkbenchWindow().getSelectionService();
        this.xmlFile = (IFile)((IStructuredSelection)service.getSelection()).getFirstElement();
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void run(IAction action) {
        if (!this.xmlFile.getLocation().getFileExtension().equals("xml")) {
            MessageDialog.openError((Shell)this.shell, (String)"The selected file is not XML file. To perform monitoring Analysis and Backpropagation please select the XML file created during the code generation phase. ", (String)"Monitoring Analysis and Backpropagation has failed");
        }
        try {
            if (this.chessFile == null) {
                this.chessFile = this.handleBrowseFile("Monitoring backpropagation from XML", "Please choose the target model");
            }
            this.backpropagateMonitoringMeasures(this.xmlFile, this.chessFile);
            MessageDialog.openInformation((Shell)this.shell, (String)"Monitoring backpropagation", (String)"The backpropagation has been successfully executed.");
        }
        catch (Exception exMB) {
            if (!exMB.getMessage().isEmpty()) {
                MessageDialog.openError((Shell)this.shell, (String)"Monitoring backpropagation", (String)exMB.getMessage());
            }
            MessageDialog.openError((Shell)this.shell, (String)"Monitoring backpropagation", (String)"The backpropagation has not been successfully executed.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void backpropagateMonitoringMeasures(final IFile xmlMonFile, final IFile chessModFile) {
        try {
            ProgressMonitorDialog progDialog = new ProgressMonitorDialog(this.shell);
            progDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Backpropagating monitored values to the CHESS model ...", 100);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    IPath chessModelPath = chessModFile.getLocation();
                    URI transformationURI0 = URI.createURI((String)"platform:/plugin/org.polarsys.chess.monitoring/transforms/MonitoringXML2Chess.qvto");
                    TransformationExecutor executor0 = new TransformationExecutor(transformationURI0);
                    XML_MODEL_PATH = xmlMonFile.getLocation().toString();
                    URI xmlURI = URI.createFileURI((String)XML_MODEL_PATH);
                    ExecutionContextImpl context0 = new ExecutionContextImpl();
                    Resource inXMLResource = LaunchBackpropagation.this.readMonitoringXML(xmlURI);
                    EList xmlObj = inXMLResource.getContents();
                    XML_MODEL_RESOURCE = inXMLResource;
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    BasicModelExtent xmlMM = new BasicModelExtent((List)xmlObj);
                    UML_MODEL_PATH = chessModelPath.toString();
                    URI chessURI = URI.createFileURI((String)UML_MODEL_PATH);
                    Resource inChessResource = resourceSet.getResource(chessURI, true);
                    EList chessObj = inChessResource.getContents();
                    UML_MODEL_RESOURCE = inChessResource;
                    BasicModelExtent chessMM = new BasicModelExtent((List)chessObj);
                    StringBufferLog log = new StringBufferLog();
                    context0.setLog((Log)log);
                    ExecutionDiagnostic result0 = executor0.execute((ExecutionContext)context0, new ModelExtent[]{xmlMM, chessMM});
                    System.out.println(String.valueOf(result0.getSeverity()) + " " + result0.getCode() + " " + result0.getMessage());
                    if (result0.getSeverity() == 0) {
                        System.out.println("OK!!");
                        System.out.println(log.getContents());
                        try {
                            inXMLResource.save(Collections.emptyMap());
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                        try {
                            inChessResource.save(Collections.emptyMap());
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    } else {
                        System.out.print("ERROR!!");
                        throw new OperationCanceledException(result0.getMessage());
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        LaunchBackpropagation.this.chessFile.getProject().refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    monitor.worked(100);
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    protected Resource readMonitoringXML(URI uri) {
        MonitoringxmlPackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xml", new MonitoringxmlResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        return resource;
    }

    public IPath getAbsoluteWorkflowPath(String relPath, String bundlename) {
        Bundle bundle = Platform.getBundle((String)bundlename);
        URL fileLocation = null;
        try {
            fileLocation = FileLocator.toFileURL((URL)bundle.getEntry(relPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path p = new Path(new File(fileLocation.getFile()).getAbsolutePath());
        return p;
    }

    public void saveResource(XtextResource resource, URI uri) {
        resource.setModified(true);
        try {
            HashMap<String, Boolean> saveOptions = new HashMap<String, Boolean>();
            saveOptions.put(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
            resource.setURI(uri);
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IFile handleBrowseFile(String title, String message) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                String[] extensions = null;
                extensions = new String[]{"uml"};
                try {
                    ret = LaunchBackpropagation.isUMLResource((IResource)element, extensions);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
        dialog.setInput((Object)this.root);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return null;
        }
        Object results = dialog.getFirstResult();
        if (results != null && results instanceof IFile) {
            IFile currentFile = (IFile)results;
            return currentFile;
        }
        if (results != null && (results instanceof IFolder || results instanceof IProject)) {
            MessageDialog.openError((Shell)this.shell, (String)"Monitoring backpropagation", (String)"The analysis has not been successfully executed. Please select a valid target model.");
            return null;
        }
        return null;
    }

    private static boolean isUMLResource(IResource resource, String[] extensions) throws CoreException {
        block8: {
            block7: {
                IResource[] members;
                if (!(resource instanceof IContainer)) break block7;
                if (!((IContainer)resource).isAccessible()) break block8;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (LaunchBackpropagation.isUMLResource(member, extensions)) {
                        return true;
                    }
                    ++n2;
                }
                break block8;
            }
            if (resource instanceof IFile) {
                IFile currentFile = (IFile)resource;
                if (extensions == null) {
                    return true;
                }
                if (currentFile.getFileExtension() != null) {
                    int i = 0;
                    while (i < extensions.length) {
                        String extension = extensions[i];
                        if (currentFile.getFileExtension().toUpperCase().equals(extension.toUpperCase())) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }

    public static String getXMLPath() {
        return XML_MODEL_PATH;
    }

    public static Resource getXMLResource() {
        return XML_MODEL_RESOURCE;
    }

    public static String getModelPath() {
        return UML_MODEL_PATH;
    }

    public static Resource getModelResource() {
        return UML_MODEL_RESOURCE;
    }
}

