/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.trace.contract.property;

import eu.fbk.tools.adapter.results.CheckResult;
import eu.fbk.tools.adapter.results.ContractPropertyValidationResult;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.results.Trace;
import eu.fbk.tools.adapter.ui.views.trace.TraceTreeObject;
import eu.fbk.tools.adapter.ui.views.trace.contract.property.PropertyTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.FailureTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.SuccessTreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import eu.fbk.tools.adapter.ui.views.tree.UnknownTreeObject;
import java.util.Comparator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;

public class PropertyTraceTreeViewContentProvider
extends TreeViewContentProvider {
    private ModelCheckResult resultModel;

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof ModelCheckResult) {
            this.resultModel = (ModelCheckResult)newInput;
        }
        super.inputChanged(v, oldInput, newInput);
    }

    @Override
    protected void initialize() {
        if (this.getInvisibleRoot() == null) {
            return;
        }
        this.getInvisibleRoot().clear();
        if (this.resultModel == null) {
            return;
        }
        this.showResult();
    }

    private void showResult() {
        EList propertyValidationResults = this.resultModel.getPropertyValidationResults();
        ECollections.sort((EList)propertyValidationResults, (Comparator)new Comparator<ContractPropertyValidationResult>(){

            @Override
            public int compare(ContractPropertyValidationResult o1, ContractPropertyValidationResult o2) {
                return o1.getTimeStamp() > o2.getTimeStamp() ? -1 : 1;
            }
        });
        for (ContractPropertyValidationResult propertyValidationResult : propertyValidationResults) {
            PropertyTreeObject propertyTreeObject = new PropertyTreeObject(propertyValidationResult.getName(), propertyValidationResult.getName());
            propertyTreeObject.setContentProvider(propertyValidationResult);
            propertyTreeObject.setTooltip("Validation property: " + propertyValidationResult.getName() + "\nType: " + propertyValidationResult.getCheckType());
            this.getInvisibleRoot().addChild(propertyTreeObject);
            EList checkResults = propertyValidationResult.getCheckResults();
            if (checkResults == null || checkResults.isEmpty()) {
                propertyTreeObject.addChild(new UnknownTreeObject("Check result not available"));
                continue;
            }
            for (CheckResult checkResult : checkResults) {
                switch (checkResult.getValue().trim().toLowerCase()) {
                    case "ok": {
                        propertyTreeObject.addChild(new SuccessTreeObject());
                        break;
                    }
                    case "not_ok": {
                        propertyTreeObject.addChild(new FailureTreeObject());
                        break;
                    }
                    case "unknown": {
                        propertyTreeObject.addChild(new UnknownTreeObject());
                    }
                }
                EList traces = checkResult.getTraces();
                if (traces == null) continue;
                for (Trace trace : traces) {
                    StringBuffer message = new StringBuffer();
                    StringBuffer tooltip = new StringBuffer();
                    message.append("Trace");
                    TraceTreeObject traceTreeObject = new TraceTreeObject(trace.getId(), message.toString());
                    traceTreeObject.setContentProvider(trace);
                    propertyTreeObject.addChild(traceTreeObject);
                    traceTreeObject.setTooltip(tooltip.toString());
                }
            }
        }
    }
}

