/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result.contract;

import eu.fbk.tools.adapter.ocra.CheckContractResultBuilder;
import eu.fbk.tools.adapter.ocra.OcraOutput;
import eu.fbk.tools.adapter.results.ModelCheckResult;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.views.trace.TraceViewPart;
import eu.fbk.tools.adapter.ui.views.trace.contract.implementation.ContractImplementationTraceViewer;
import eu.fbk.tools.adapter.ui.views.trace.contract.property.ValidationPropertyTraceViewer;
import eu.fbk.tools.adapter.ui.views.trace.contract.refinement.ContractRefinementTraceViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContractResultProcessor
extends ResultProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CheckContractResultProcessor.class);
    private ModelCheckResult contractCheckResult;

    public CheckContractResultProcessor(String functionName) {
        super(functionName);
    }

    @Override
    public boolean processResult() {
        if (!this.resultFileExists()) {
            return false;
        }
        this.contractCheckResult = null;
        CheckContractResultBuilder resultBuilder = new CheckContractResultBuilder();
        OcraOutput ocraOutput = resultBuilder.unmarshalResult(this.resultFile);
        if (ocraOutput == null || ocraOutput.getOcraResult() == null || ocraOutput.getOcraResult().isEmpty()) {
            this.displayError(this.functionName, "Error while umarshalling the result. For more info see the console");
            return false;
        }
        this.contractCheckResult = resultBuilder.buildResult(ocraOutput);
        if (this.contractCheckResult == null) {
            this.displayError(this.functionName, "Internal error while building the result. For more info see the console");
            return false;
        }
        return true;
    }

    @Override
    public void displayResult() {
        if (this.contractCheckResult == null) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            TraceViewPart traceViewPart = null;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                EList contractCheckResults = this.contractCheckResult.getContractCheckResults();
                if (contractCheckResults != null && !contractCheckResults.isEmpty()) {
                    if (this.functionName.equals("ocra_check_refinement")) {
                        traceViewPart = (ContractRefinementTraceViewer)page.showView("eu.fbk.tools.adapter.ui.views.trace.contract.refinement.ContractRefinementTraceViewer", null, 2);
                    } else if (this.functionName.equals("ocra_check_implementation")) {
                        traceViewPart = (ContractImplementationTraceViewer)page.showView("eu.fbk.tools.adapter.ui.views.trace.contract.implementation.ContractImplementationTraceViewer", null, 2);
                    } else if (this.functionName.equals("ocra_check_composite_impl")) {
                        traceViewPart = (ContractImplementationTraceViewer)page.showView("eu.fbk.tools.adapter.ui.views.trace.contract.implementation.ContractImplementationTraceViewer", null, 2);
                    }
                } else {
                    EList propertyValidationResults = this.contractCheckResult.getPropertyValidationResults();
                    if (propertyValidationResults != null && !propertyValidationResults.isEmpty() && this.functionName.equals("ocra_check_validation_prop")) {
                        traceViewPart = (ValidationPropertyTraceViewer)page.showView("eu.fbk.tools.adapter.ui.views.trace.contract.property.ValidationPropertyTraceViewer", null, 2);
                    }
                }
                if (traceViewPart != null) {
                    IContentProvider provider = traceViewPart.getTreeViewer().getContentProvider();
                    if (provider == null) {
                        return;
                    }
                    provider.inputChanged((Viewer)traceViewPart.getTreeViewer(), null, (Object)this.contractCheckResult);
                    traceViewPart.refresh();
                    page.activate((IWorkbenchPart)traceViewPart);
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        });
    }
}

