/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.result;

import eu.fbk.tools.adapter.ui.result.DefaultResultProcessor;
import eu.fbk.tools.adapter.ui.result.ResultProcessor;
import eu.fbk.tools.adapter.ui.result.behaviour.CheckModelResultProcessor;
import eu.fbk.tools.adapter.ui.result.behaviour.GenerateIc3iaProofResultProcessor;
import eu.fbk.tools.adapter.ui.result.behaviour.GenerateVMTModelResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.CheckContractResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.GetParametersFromParamArchitectureResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.InstantiateParamArchitectureResultProcessor;
import eu.fbk.tools.adapter.ui.result.contract.PrintSystemImplementationResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ComputeFaultTreeResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ComputeFmeaTableResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ExpandFeiResultProcessor;
import eu.fbk.tools.adapter.ui.result.safety.ExtendModelResultProcessor;
import eu.fbk.tools.adapter.ui.result.satisfiability.CheckSatisfiabilityResultProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResultProcessorFactory.class);

    public static ResultProcessor getProcessor(String functionName) {
        logger.debug("Requesting result processor for function " + functionName);
        switch (functionName) {
            case "ocra_check_validation_prop": 
            case "ocra_check_refinement": 
            case "ocra_check_composite_impl": 
            case "ocra_check_implementation": {
                return new CheckContractResultProcessor(functionName);
            }
            case "xsap_compute_fault_tree": 
            case "ocra_compute_fault_tree": 
            case "xsap_redundancy_analysis_compute_fault_tree": {
                return new ComputeFaultTreeResultProcessor(functionName);
            }
            case "ocra_print_system_implementation": {
                return new PrintSystemImplementationResultProcessor(functionName);
            }
            case "nuxmv_check_model": {
                return new CheckModelResultProcessor(functionName);
            }
            case "nuxmv_vmt_model_generator": {
                return new GenerateVMTModelResultProcessor(functionName);
            }
            case "ic3ia_proof_generation": {
                return new GenerateIc3iaProofResultProcessor(functionName);
            }
            case "check_satisfiability": {
                return new CheckSatisfiabilityResultProcessor(functionName);
            }
            case "expand_fault_extensions": {
                return new ExpandFeiResultProcessor(functionName);
            }
            case "xsap_extend_model": {
                return new ExtendModelResultProcessor(functionName);
            }
            case "xsap_compute_fmea_table": {
                return new ComputeFmeaTableResultProcessor(functionName);
            }
            case "ocra_get_required_arch_params": {
                return new GetParametersFromParamArchitectureResultProcessor(functionName);
            }
            case "ocra_instantiate_parametric_arch": {
                return new InstantiateParamArchitectureResultProcessor(functionName);
            }
        }
        return new DefaultResultProcessor(functionName);
    }
}

