/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences;

import eu.fbk.tools.adapter.ui.Activator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceUtils {
    public static String getOslcServiceProviderRegistryUrl() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String baseUrl = store.getString("oslc.serviceprovider.catalog.baseurl");
        String pathUrl = store.getString("oslc.serviceprovider.catalog.path");
        if (baseUrl == null || pathUrl == null) {
            return null;
        }
        return String.valueOf(baseUrl) + pathUrl;
    }

    public static String getOslcAutomationServiceProviderId(String plantId) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String serviceProviderId = store.getString(plantId);
        if (serviceProviderId == null) {
            return null;
        }
        return serviceProviderId;
    }

    public static Set<String> getOslcAutomationServiceProviderIds() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String joinedServiceProviderIds = store.getString("oslc.serviceprovider.ids");
        if (joinedServiceProviderIds == null || joinedServiceProviderIds.isEmpty()) {
            return Collections.emptySet();
        }
        return PreferenceUtils.deserializeServiceProvidersIds(joinedServiceProviderIds);
    }

    public static Set<String> deserializeServiceProvidersIds(String joinedServiceProviderIds) {
        return new HashSet<String>(Arrays.asList(joinedServiceProviderIds.split(",")));
    }

    public static boolean isOslcEnabled() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("oslc.serviceprovider.enables");
    }

    public static boolean isDevelopmentModeEnabled() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("debug.developmentMode");
    }
}

