/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.xsap.RedundancyAnalysisComputeFaultTree;
import java.net.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RedundancyAnalysisComputeFaultTreeParametersDialog
extends Dialog {
    private RedundancyAnalysisComputeFaultTree function;
    private Combo kindCombo;
    private Combo modelTypeCombo;
    private Text faultTreeFileNameText;
    private Text gatesFileNameText;
    private Text eventsFileNameText;
    private Button asyncCheckBox;
    private Boolean asyncExecution = false;
    private boolean goAhead = false;
    private String[] architectureTypes = new String[]{RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.custom.name(), RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.linear.name(), RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.rectangular.name(), RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.random.name()};
    private String[] modelTypes = new String[]{RedundancyAnalysisComputeFaultTree.ModelType.mod_abs.name(), RedundancyAnalysisComputeFaultTree.ModelType.mod_con.name()};

    public RedundancyAnalysisComputeFaultTreeParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public RedundancyAnalysisComputeFaultTreeParametersDialog(Shell parentShell, RedundancyAnalysisComputeFaultTree function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Compute Fault Tree Parameters");
    }

    protected void okPressed() {
        try {
            this.function.setArchitectureType(RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.valueOf((String)this.kindCombo.getItems()[this.kindCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        try {
            this.function.setModelType(RedundancyAnalysisComputeFaultTree.ModelType.valueOf((String)this.modelTypeCombo.getItems()[this.modelTypeCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        if (!this.faultTreeFileNameText.getText().isEmpty()) {
            this.function.setFaultTree(FileUtils.stringToURI((String)this.faultTreeFileNameText.getText()));
        }
        if (!this.gatesFileNameText.getText().isEmpty()) {
            this.function.setGates(FileUtils.stringToURI((String)this.gatesFileNameText.getText()));
        }
        if (!this.eventsFileNameText.getText().isEmpty()) {
            this.function.setEvents(FileUtils.stringToURI((String)this.eventsFileNameText.getText()));
        }
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 400;
        Label lblKind = new Label(container2, 0);
        lblKind.setText("Architecture Kind");
        this.kindCombo = new Combo(container2, 8);
        this.kindCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.kindCombo, this.architectureTypes, this.function.getArchitectureType() == null ? "" : this.function.getArchitectureType().name());
        Label lblModelType = new Label(container2, 0);
        lblModelType.setText("Model Type");
        this.modelTypeCombo = new Combo(container2, 8);
        this.modelTypeCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.modelTypeCombo, this.modelTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblFaultTreeFileName = new Label(container2, 0);
        lblFaultTreeFileName.setText("Result Fault Tree File Name");
        this.faultTreeFileNameText = new Text(container2, 2052);
        this.faultTreeFileNameText.setLayoutData((Object)new GridData(768));
        URI faultTreeFile = this.function.getFaultTree();
        this.faultTreeFileNameText.setText(faultTreeFile == null ? "" : faultTreeFile.toString());
        Label lblGatesFileName = new Label(container2, 0);
        lblGatesFileName.setText("Result Gates File Name");
        this.gatesFileNameText = new Text(container2, 2052);
        this.gatesFileNameText.setLayoutData((Object)new GridData(768));
        URI gatesTreeFile = this.function.getGates();
        this.gatesFileNameText.setText(gatesTreeFile == null ? "" : gatesTreeFile.toString());
        Label lblEventsFileName = new Label(container2, 0);
        lblEventsFileName.setText("Result Events File Name");
        this.eventsFileNameText = new Text(container2, 2052);
        this.eventsFileNameText.setLayoutData((Object)new GridData(768));
        URI eventsFile = this.function.getEvents();
        this.eventsFileNameText.setText(eventsFile == null ? "" : eventsFile.toString());
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(650, 400);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

