/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ocra.GenerateMiterArchitecture;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import java.net.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenerateMiterArchitectureParametersDialog
extends Dialog {
    private GenerateMiterArchitecture function;
    private Combo timeModelCombo;
    private Combo modelTypeCombo;
    private Button asyncCheckBox;
    private Button disableAsyncConstraintsBox;
    private Text miterArchitectureFileNameText;
    private Text miterMapFileNameText;
    private Text faultsDefFileNameText;
    private Text varListFileNameText;
    private Boolean asyncExecution = false;
    private Boolean disableAsyncConstraints = false;
    private String[] timeModels = new String[]{OcraFunction.TimeModel.discrete.name(), OcraFunction.TimeModel.hybrid.name(), OcraFunction.TimeModel.timed.name()};
    private String[] modelTypes = new String[]{GenerateMiterArchitecture.ModelType.mod_abs.name(), GenerateMiterArchitecture.ModelType.mod_con.name()};
    private boolean goAhead = false;

    public GenerateMiterArchitectureParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public GenerateMiterArchitectureParametersDialog(Shell parentShell, GenerateMiterArchitecture function, Boolean asyncExecution, Boolean disableAsyncConstraints) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
        this.disableAsyncConstraints = disableAsyncConstraints == null ? false : disableAsyncConstraints;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Generate Miter Architecture Parameters");
    }

    protected void okPressed() {
        try {
            this.function.setTimeModel(OcraFunction.TimeModel.valueOf((String)this.timeModelCombo.getItems()[this.timeModelCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        try {
            this.function.setModelType(GenerateMiterArchitecture.ModelType.valueOf((String)this.modelTypeCombo.getItems()[this.modelTypeCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        if (!this.miterArchitectureFileNameText.getText().isEmpty()) {
            this.function.setMiterArchitecture(FileUtils.stringToURI((String)this.miterArchitectureFileNameText.getText()));
        }
        if (!this.miterMapFileNameText.getText().isEmpty()) {
            this.function.setMiterMapping(FileUtils.stringToURI((String)this.miterMapFileNameText.getText()));
        }
        if (!this.faultsDefFileNameText.getText().isEmpty()) {
            this.function.setFaultsDef(FileUtils.stringToURI((String)this.faultsDefFileNameText.getText()));
        }
        if (!this.varListFileNameText.getText().isEmpty()) {
            this.function.setVarList(FileUtils.stringToURI((String)this.varListFileNameText.getText()));
        }
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.disableAsyncConstraints = this.disableAsyncConstraintsBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        Label lblModelFiletName = new Label(container2, 0);
        lblModelFiletName.setText("Architecture File Name");
        Text modelFileNameText = new Text(container2, 2052);
        modelFileNameText.setLayoutData((Object)new GridData(768));
        modelFileNameText.setText(this.function.getContractModel() == null ? "" : this.function.getContractModel().getPath().toString());
        modelFileNameText.setEditable(false);
        Label lblMapFileName = new Label(container2, 0);
        lblMapFileName.setText("Map File Name");
        Text mapFileNameText = new Text(container2, 2052);
        mapFileNameText.setLayoutData((Object)new GridData(768));
        mapFileNameText.setText(this.function.getComponentsMapping() == null ? "" : this.function.getComponentsMapping().getPath().toString());
        mapFileNameText.setEditable(false);
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 400;
        Label lblCheck = new Label(container2, 0);
        lblCheck.setText("Time Model");
        this.timeModelCombo = new Combo(container2, 8);
        this.timeModelCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.timeModelCombo, this.timeModels, this.function.getTimeModel() == null ? "" : this.function.getTimeModel().name());
        Label lblModelType = new Label(container2, 0);
        lblModelType.setText("Model Type");
        this.modelTypeCombo = new Combo(container2, 8);
        this.modelTypeCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.modelTypeCombo, this.modelTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblMiterArchitectureFileName = new Label(container2, 0);
        lblMiterArchitectureFileName.setText("Result Architecture File Name");
        this.miterArchitectureFileNameText = new Text(container2, 2052);
        this.miterArchitectureFileNameText.setLayoutData((Object)new GridData(768));
        URI miterArchitectureFile = this.function.getMiterArchitecture();
        this.miterArchitectureFileNameText.setText(miterArchitectureFile == null ? "" : miterArchitectureFile.toString());
        Label lblMiterMapFileName = new Label(container2, 0);
        lblMiterMapFileName.setText("Result Miter Map File Name");
        this.miterMapFileNameText = new Text(container2, 2052);
        this.miterMapFileNameText.setLayoutData((Object)new GridData(768));
        URI miterMapFile = this.function.getMiterMapping();
        this.miterMapFileNameText.setText(miterMapFile == null ? "" : miterMapFile.toString());
        Label lblFaultXmlFileName = new Label(container2, 0);
        lblFaultXmlFileName.setText("Result Fault Xml File Name");
        this.faultsDefFileNameText = new Text(container2, 2052);
        this.faultsDefFileNameText.setLayoutData((Object)new GridData(768));
        URI faultsDefFile = this.function.getFaultsDef();
        this.faultsDefFileNameText.setText(faultsDefFile == null ? "" : faultsDefFile.toString());
        Label lblVarListFileName = new Label(container2, 0);
        lblVarListFileName.setText("Result Var List File Name");
        this.varListFileNameText = new Text(container2, 2052);
        this.varListFileNameText.setLayoutData((Object)new GridData(768));
        URI varListFile = this.function.getVarList();
        this.varListFileNameText.setText(varListFile == null ? "" : varListFile.toString());
        this.disableAsyncConstraintsBox = new Button(container, 32);
        this.disableAsyncConstraintsBox.setText("Disable Async Constraints");
        this.disableAsyncConstraintsBox.setSelection(this.disableAsyncConstraints.booleanValue());
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(700, 450);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    public Boolean getDisableAsyncConstraints() {
        return this.disableAsyncConstraints;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

