/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.behaviour;

import eu.fbk.tools.adapter.nuxmv.GenerateVMTModel;
import eu.fbk.tools.adapter.nuxmv.NuxmvFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VMTModelGenerationParametersDialog
extends Dialog {
    private GenerateVMTModel function;
    private Combo comboCheckType;
    private Text propertyText;
    private Text propertyIndex;
    private Button asyncCheckBox;
    private Boolean asyncExecution = false;
    private Boolean internalProperty = true;
    private String[] checkTypes = new String[]{"invar", "ltlspec"};
    private boolean goAhead = false;

    public VMTModelGenerationParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public VMTModelGenerationParametersDialog(Shell parentShell, GenerateVMTModel function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("VMT Model Generation parameters");
    }

    protected void okPressed() {
        if (this.internalProperty.booleanValue()) {
            this.function.setPropertyIndex(StringUtils.isEmpty((CharSequence)this.propertyIndex.getText()) ? null : Integer.valueOf(this.propertyIndex.getText()));
            this.function.setCheckType(null);
            this.function.setFormula(null);
        } else {
            try {
                this.function.setCheckType(NuxmvFunction.CheckType.valueOf((String)this.comboCheckType.getItems()[this.comboCheckType.getSelectionIndex()]));
            }
            catch (Exception exception) {}
            this.function.setFormula(this.propertyText.getText());
            this.function.setPropertyIndex(null);
        }
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new RowLayout());
        Label label = new Label(container2, 0);
        label.setText("Property location: ");
        final Button internalButton = new Button(container2, 16);
        internalButton.setText("Internal");
        final Button externalButton = new Button(container2, 16);
        externalButton.setText("External");
        Composite container3 = new Composite(container, 0);
        container3.setLayout((Layout)new GridLayout(2, false));
        Label lblPropertyIndex = new Label(container3, 0);
        lblPropertyIndex.setText("Property Index");
        this.propertyIndex = new Text(container3, 2048);
        if (this.function.getPropertyIndex() != null) {
            this.propertyIndex.setText(this.function.getPropertyIndex().toString());
        }
        this.propertyIndex.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        GridData gd_combo = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 250;
        Label lblCheck = new Label(container3, 0);
        lblCheck.setText("Check Type");
        this.comboCheckType = new Combo(container3, 8);
        this.comboCheckType.setLayoutData((Object)gd_combo);
        this.setComboValues(this.comboCheckType, this.checkTypes, this.function.getCheckType() == null ? "" : this.function.getCheckType().name());
        Label lblProperty = new Label(container3, 0);
        lblProperty.setText("Property\nExpression");
        this.propertyText = new Text(container3, 2114);
        this.propertyText.setLayoutData((Object)new GridData(1808));
        if (!StringUtils.isBlank((CharSequence)this.function.getFormula())) {
            this.propertyText.setText(this.function.getFormula());
        }
        GridData gd_text = new GridData(0, 0, true, false, 1, 1);
        gd_text.widthHint = 250;
        gd_text.heightHint = 150;
        this.propertyText.setLayoutData((Object)gd_text);
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        internalButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VMTModelGenerationParametersDialog.this.updateInternalButtonState(internalButton);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        externalButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VMTModelGenerationParametersDialog.this.updateExternalButtonState(externalButton);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.function.getPropertyIndex() != null) {
            internalButton.setSelection(true);
            externalButton.setSelection(false);
        } else if (!StringUtils.isEmpty((CharSequence)this.function.getFormula())) {
            internalButton.setSelection(false);
            externalButton.setSelection(true);
        } else {
            internalButton.setSelection(true);
            externalButton.setSelection(false);
        }
        this.updateInternalButtonState(internalButton);
        this.updateExternalButtonState(externalButton);
        container.pack();
        return container;
    }

    private void updateInternalButtonState(Button internalButton) {
        if (internalButton.getSelection()) {
            this.internalProperty = true;
            this.propertyIndex.setEnabled(true);
            this.comboCheckType.setEnabled(false);
            this.propertyText.setEnabled(false);
        }
    }

    private void updateExternalButtonState(Button externalButton) {
        if (externalButton.getSelection()) {
            this.internalProperty = false;
            this.propertyIndex.setEnabled(false);
            this.comboCheckType.setEnabled(true);
            this.propertyText.setEnabled(true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

