/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.software;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.kratos.InjectProperty;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectPropertyIntoSwModelCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(InjectPropertyIntoSwModelCommand.class);
    private InjectProperty function;

    public InjectPropertyIntoSwModelCommand() {
        super("kratos_property_injector", "Inject property into sw model", "tools.kratos_property_injector.executable", "tools.kratos_property_injector.timeout");
    }

    @Override
    protected boolean initialize() {
        this.function = new InjectProperty();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        String softwarePropertyFileName = this.getFileNameParameter(event, "software_property", "txt", "Choose the software property file");
        if (StringUtils.isBlank((CharSequence)softwarePropertyFileName)) {
            this.displayError(this.getCommandDescription(), "Software property to inject (file) has not been specified, can't execute the command.");
            logger.error("Software property to inject (file) has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set sw property to inject " + softwarePropertyFileName);
        String softwareModelFileName = this.getFileNameParameter(event, "software_model", "k2", "Choose the software model file");
        if (StringUtils.isBlank((CharSequence)softwareModelFileName)) {
            this.displayError(this.getCommandDescription(), "Software model (file) has not been specified, can't execute the command.");
            logger.error("Software model (file) has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set software model to " + softwareModelFileName);
        this.function.setSoftwarePropertyURI(FileUtils.stringToURI((String)softwarePropertyFileName));
        this.function.setSoftwareModelURI(FileUtils.stringToURI((String)softwareModelFileName));
        return true;
    }
}

