/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.ui.dialog.safety.ComputeFmeaTableParametersDialog;
import eu.fbk.tools.adapter.xsap.ComputeFmeaTable;
import eu.fbk.tools.adapter.xsap.XsapFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeFmeaTableCommand
extends AbstractSafetyAnalysisCommand {
    private static final Logger logger = LoggerFactory.getLogger(ComputeFmeaTableCommand.class);
    private ComputeFmeaTable function;
    protected String faultModesFileName = null;
    private String boundLength = null;

    public ComputeFmeaTableCommand() {
        super("Compute FMEA Table");
    }

    @Override
    protected boolean initialize() {
        this.function = new ComputeFmeaTable();
        this.faultModesFileName = null;
        this.boundLength = null;
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        this.faultModesFileName = this.getFileNameParameter(event, "fault_modes", "xml", "Choose the fault modes file");
        if (StringUtils.isBlank((CharSequence)this.faultModesFileName)) {
            this.displayError(this.getCommandDescription(), "Fault modes file has not been specified, can't execute the command.");
            logger.error("Fault modes file has not been specified, can't execute the command.");
            return false;
        }
        this.function.setFaultModes(FileUtils.stringToURI((String)this.faultModesFileName));
        logger.debug("Set fault modes file to " + this.faultModesFileName);
        this.function.setProperties(event.getParameter("properties"));
        String algorithmType = event.getParameter("algorithm_type");
        if (algorithmType != null) {
            try {
                this.function.setAlgorithmType(XsapFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        this.boundLength = event.getParameter("bound_length");
        if (!StringUtils.isBlank((CharSequence)this.boundLength)) {
            try {
                this.function.setBoundLength(Integer.decode(this.boundLength));
            }
            catch (NumberFormatException numberFormatException) {
                String errMsg = "Invalid bound_length parameter value: " + this.boundLength + " , can't execute the command.";
                this.displayError(this.getCommandDescription(), errMsg);
                logger.error(errMsg);
                return false;
            }
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ComputeFmeaTableParametersDialog dialog = new ComputeFmeaTableParametersDialog(ComputeFmeaTableCommand.this.activeShell, ComputeFmeaTableCommand.this.function, ComputeFmeaTableCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        ComputeFmeaTableCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        if (StringUtils.isBlank((CharSequence)this.function.getProperties())) {
            this.displayError(this.getCommandDescription(), "List of properties is missing, can't execute the command.");
            logger.error("List of properties is missing");
            return false;
        }
        return true;
    }
}

