/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.PrintImplementationTemplate;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintImplementationTemplateCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(PrintImplementationTemplateCommand.class);
    private PrintImplementationTemplate function;
    private String mapFileName;

    public PrintImplementationTemplateCommand() {
        super("Generate system implementation");
    }

    @Override
    protected boolean initialize() {
        this.function = new PrintImplementationTemplate();
        this.mapFileName = null;
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.mapFileName = this.getFileNameParameter(event, "map_file", "txt", "Choose the map file");
        if (StringUtils.isBlank((CharSequence)this.mapFileName)) {
            this.displayError(this.getCommandDescription(), "Map file has not been specified, can't execute the command.");
            logger.error("Map file has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set component to model mapping filename to " + this.mapFileName);
        this.function.setComponentsMapping(FileUtils.stringToURI((String)this.mapFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        String componentName = event.getParameter("component_name");
        this.function.setComponentName(componentName);
        if (componentName != null) {
            logger.debug("Set component name to " + componentName);
        }
        return true;
    }
}

