/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP;

import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.Event;
import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.FTAModel;
import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.Gate;
import eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.impl.EmftaFactoryImpl;
import eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP.generated.FaultTree;
import eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP.generated.GateType;
import eu.fbk.eclipse.standardtools.faultTreeViewer.xSAP.generated.ObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class FaultTreeBuilder {
    private static FaultTreeBuilder faultTreeBuilder;

    public static FaultTreeBuilder getInstance() {
        if (faultTreeBuilder == null) {
            faultTreeBuilder = new FaultTreeBuilder();
        }
        return faultTreeBuilder;
    }

    public static void main(String[] args) {
        File xmlFile = new File("ft.xml");
        try {
            FaultTree xsapFaultTree = FaultTreeBuilder.getInstance().populateFaultTreeClassesFromXml(xmlFile);
            FaultTreeBuilder.getInstance().convertFaultTreeTypeInFTAModel(xsapFaultTree);
        }
        catch (FileNotFoundException | JAXBException | XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public FaultTree populateFaultTreeClassesFromXml(File xmlFile) throws JAXBException, FileNotFoundException, XMLStreamException {
        FileInputStream in = new FileInputStream(xmlFile);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(in);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller u = context.createUnmarshaller();
        return (FaultTree)u.unmarshal(parser, FaultTree.class).getValue();
    }

    public FTAModel convertFaultTreeTypeInFTAModel(FaultTree xsapfaultTree) {
        Event mainEvent = this.createEventFromXSAPGate(xsapfaultTree.getGate(), true);
        EList<Event> allEvents = this.getAllEvents(mainEvent.getGate());
        FTAModel ftaModel = EmftaFactoryImpl.eINSTANCE.createFTAModel();
        ftaModel.setName("FTA model root");
        ftaModel.setRoot(mainEvent);
        ftaModel.getEvents().addAll(allEvents);
        return ftaModel;
    }

    private EList<Event> getAllEvents(Gate rootGate) {
        BasicEList events = new BasicEList();
        for (Event event : rootGate.getEvents()) {
            if (event.getGate() == null) continue;
            events.addAll(this.getAllEvents(event.getGate()));
        }
        events.addAll((Collection)rootGate.getEvents());
        return events;
    }

    private Event createEventFromXSAPEvent(GateType.Event xsapEvent, boolean showDescription) {
        String name = xsapEvent.getName();
        if (showDescription) {
            name = String.valueOf(name) + "\n (" + xsapEvent.getDescription() + ") ";
        }
        String description = xsapEvent.getDescription();
        String probability = xsapEvent.getProbability();
        Event event = EmftaFactoryImpl.eINSTANCE.createEvent();
        event.setName(name);
        event.setDescription(description);
        if (probability != null) {
            event.setProbability(Double.parseDouble(probability));
        }
        return event;
    }

    private Event createEventFromXSAPGate(GateType xsapGate, boolean showDescription) {
        String name = xsapGate.getName();
        if (showDescription) {
            name = String.valueOf(name) + "\n (" + xsapGate.getDescription() + ") ";
        }
        String description = xsapGate.getDescription();
        String probability = xsapGate.getProbability();
        Event event = EmftaFactoryImpl.eINSTANCE.createEvent();
        event.setName(name);
        event.setDescription(description);
        event.setGate(this.getGateFromXSAPGate(xsapGate));
        if (probability != null) {
            event.setProbability(Double.parseDouble(probability));
        }
        return event;
    }

    private Gate getGateFromXSAPGate(GateType xsapGateRoot) {
        eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType gateType;
        String type;
        String desc = xsapGateRoot.getDescription();
        switch (type = xsapGateRoot.getType()) {
            case "OR": {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.OR;
                break;
            }
            case "XOR": {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.XOR;
                break;
            }
            case "AND": {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.AND;
                break;
            }
            case "PAND": {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.PRIORITY_AND;
                break;
            }
            case "NULL": {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.AND;
                break;
            }
            default: {
                gateType = eu.fbk.eclipse.standardtools.faultTreeViewer.emfta.GateType.OR;
            }
        }
        Gate gate = EmftaFactoryImpl.eINSTANCE.createGate();
        gate.setType(gateType);
        gate.setDescription(desc);
        for (GateType.Event xsapEvent : xsapGateRoot.getEvent()) {
            Event event = this.createEventFromXSAPEvent(xsapEvent, true);
            gate.getEvents().add((Object)event);
        }
        for (GateType xsapGate : xsapGateRoot.getGate()) {
            gate.getEvents().add((Object)this.createEventFromXSAPGate(xsapGate, false));
        }
        return gate;
    }
}

