/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.visitor;

import eu.fbk.tools.editor.c.expression.expression.AdditiveExpression;
import eu.fbk.tools.editor.c.expression.expression.DecimalLiteral;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.c.statement.statement.CompoundStatement;
import eu.fbk.tools.editor.c.statement.statement.ForStatement;
import eu.fbk.tools.editor.c.statement.statement.IterationStatement;
import eu.fbk.tools.editor.c.statement.statement.Statement;
import eu.fbk.tools.editor.c.visitor.IdentityVisitor;
import eu.fbk.tools.editor.c.visitor.VarSubstitutionVisitor;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;

public class UnrollStaticLoopVisitor
extends IdentityVisitor {
    private VarSubstitutionVisitor var_substitutor = new VarSubstitutionVisitor();
    private EMap<String, Integer> array_length = new BasicEMap();

    @Override
    public EObject process(EObject o) throws Exception {
        this.array_length.clear();
        return super.process(o);
    }

    public EObject process(EObject o, EMap<String, Integer> array_len) throws Exception {
        this.array_length.clear();
        this.array_length.addAll(array_len);
        return super.process(o);
    }

    @Override
    public void visitForStatement(ForStatement s) throws Exception {
        Identifier i1 = (Identifier)this.get((EObject)s.getInitId());
        Expression e1 = (Expression)this.get((EObject)s.getInit());
        Expression cond = (Expression)this.get((EObject)s.getCondition());
        Identifier i2 = (Identifier)this.get((EObject)s.getIncrementId());
        Expression e2 = (Expression)this.get((EObject)s.getIncrement());
        int start = 0;
        int end = 0;
        int inc = 0;
        boolean ok = i1.getName().equals(i2.getName());
        if (ok && e1 instanceof DecimalLiteral) {
            start = Integer.parseInt(((DecimalLiteral)e1).getValue());
        } else {
            ok = false;
        }
        if (ok && cond instanceof RelationalExpression) {
            RelationalExpression cond1 = (RelationalExpression)cond;
            Expression cond1l = cond1.getLeft();
            Expression cond1r = cond1.getRight();
            if (cond1l instanceof Identifier) {
                ok = ((Identifier)cond1l).getName().equals(i1.getName());
                if (ok && cond1r instanceof DecimalLiteral) {
                    end = Integer.parseInt(((DecimalLiteral)cond1r).getValue());
                } else if (ok && cond1r instanceof PostfixExpression) {
                    Expression pel = ((PostfixExpression)cond1r).getLeft();
                    Expression per = ((PostfixExpression)cond1r).getRight();
                    if (per != null && per instanceof Identifier && pel != null && per instanceof Identifier) {
                        if (this.array_length.containsKey((Object)((Identifier)pel).getName()) && ((Identifier)per).getName().equals("length")) {
                            end = (Integer)this.array_length.get((Object)((Identifier)pel).getName());
                        } else {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            } else {
                ok = false;
            }
        } else {
            ok = false;
        }
        String incOp = ((AdditiveExpression)e2).getOp();
        if (ok && incOp.equals("+")) {
            Expression inc_l = ((AdditiveExpression)e2).getLeft();
            Expression inc_r = ((AdditiveExpression)e2).getRight();
            if (inc_l instanceof Identifier) {
                ok = ((Identifier)inc_l).getName().equals(i1.getName());
                if (ok && inc_r instanceof DecimalLiteral) {
                    inc = Integer.parseInt(((DecimalLiteral)inc_r).getValue());
                } else {
                    ok = false;
                }
            } else if (inc_r instanceof Identifier) {
                ok = ((Identifier)inc_r).getName().equals(i1.getName());
                if (ok && inc_l instanceof DecimalLiteral) {
                    inc = Integer.parseInt(((DecimalLiteral)inc_l).getValue());
                } else {
                    ok = false;
                }
            } else {
                ok = false;
            }
        }
        if (ok) {
            Statement loop_body = (Statement)this.get((EObject)s.getStatement());
            CompoundStatement res = this.statementFactory.createCompoundStatement();
            BasicEList res_stmtlist = new BasicEList();
            BasicEMap sub = new BasicEMap();
            int i = start;
            while (i < end) {
                sub.clear();
                DecimalLiteral v = this.expressionFactory.createDecimalLiteral();
                v.setValue(Integer.toString(i));
                sub.put((Object)i1.getName(), (Object)v);
                Statement loop_body_i = (Statement)this.var_substitutor.process((EObject)loop_body, (EMap<String, EObject>)sub);
                res_stmtlist.add((Object)loop_body_i);
                i += inc;
            }
            res.setStmtList(this.statementFactory.createStatementList());
            res.getStmtList().getStatement().addAll((Collection)res_stmtlist);
            res_stmtlist.clear();
            this.put((EObject)s, (EObject)res);
        } else {
            super.visitForStatement(s);
        }
    }

    @Override
    public void visitIterationStatement(IterationStatement s) throws Exception {
        boolean ok = true;
        int end = 0;
        Identifier array_id = (Identifier)this.get((EObject)s.getListId());
        if (this.array_length.containsKey((Object)array_id.getName())) {
            end = (Integer)this.array_length.get((Object)array_id.getName());
            if (end < 0) {
                throw new Exception("UnrollLoop Exception : Upper bound of the iteration is negative. ");
            }
        } else {
            ok = false;
        }
        if (ok) {
            CompoundStatement res = this.statementFactory.createCompoundStatement();
            BasicEList res_stmtlist = new BasicEList();
            Identifier var_id = (Identifier)this.get((EObject)s.getIteratorId());
            Statement loop_body = (Statement)this.get((EObject)s.getStatement());
            BasicEMap sub = new BasicEMap();
            int i = 0;
            while (i < end) {
                PostfixExpression rep_val = this.expressionFactory.createPostfixExpression();
                Identifier left = this.expressionFactory.createIdentifier();
                left.setName(array_id.getName());
                rep_val.setLeft((Expression)left);
                DecimalLiteral index = this.expressionFactory.createDecimalLiteral();
                index.setValue(Integer.toString(i));
                rep_val.setIndex((Expression)index);
                sub.clear();
                sub.put((Object)var_id.getName(), (Object)rep_val);
                Statement loop_body_i = (Statement)this.var_substitutor.process((EObject)loop_body, (EMap<String, EObject>)sub);
                res_stmtlist.add((Object)loop_body_i);
                ++i;
            }
            res.setStmtList(this.statementFactory.createStatementList());
            res.getStmtList().getStatement().addAll((Collection)res_stmtlist);
            res_stmtlist.clear();
            this.put((EObject)s, (EObject)res);
        } else {
            super.visitIterationStatement(s);
        }
    }
}

