/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.visitor;

import eu.fbk.tools.editor.c.expression.expression.DecimalLiteral;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.Identifier;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.visitor.IdentityVisitor;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;

public class ArrayRemovalVisitor
extends IdentityVisitor {
    private String separator = "__";
    private HashSet<String> array_id_list = new HashSet();

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    private Identifier getArrayIdentifier(Expression e) {
        if (e instanceof Identifier) {
            return (Identifier)e;
        }
        Expression l = e;
        while (l instanceof PostfixExpression) {
            if (!((l = ((PostfixExpression)l).getLeft()) instanceof Identifier)) continue;
            return (Identifier)l;
        }
        return null;
    }

    public EObject process(EObject o, HashSet<String> array_id_list) throws Exception {
        if (array_id_list != null) {
            this.array_id_list.clear();
            this.array_id_list.addAll(array_id_list);
        }
        return this.process(o);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression e) throws Exception {
        boolean ok = true;
        if (e.getIndex() == null) {
            ok = false;
        }
        String index = "";
        if (ok) {
            Expression i = (Expression)this.get((EObject)e.getIndex());
            if (!(i instanceof DecimalLiteral)) {
                ok = false;
            } else {
                Identifier array_id = this.getArrayIdentifier(e.getLeft());
                if (!this.array_id_list.isEmpty() && !this.array_id_list.contains(array_id.getName())) {
                    ok = false;
                } else if (!(this.get((EObject)e.getLeft()) instanceof Identifier)) {
                    ok = false;
                } else {
                    index = ((DecimalLiteral)i).getValue();
                }
            }
        }
        if (ok) {
            String new_id_str = String.valueOf(((Identifier)this.get((EObject)e.getLeft())).getName()) + this.separator + index;
            Identifier new_id = this.expressionFactory.createIdentifier();
            new_id.setName(new_id_str);
            if (e.getRight() != null) {
                PostfixExpression res = this.expressionFactory.createPostfixExpression();
                res.setLeft((Expression)new_id);
                res.setRight((Expression)this.get((EObject)e.getRight()));
                this.put((EObject)e, (EObject)res);
            } else {
                this.put((EObject)e, (EObject)new_id);
            }
        } else {
            super.visitPostfixExpression(e);
        }
    }
}

