/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AllocationEndKind implements Enumerator
{
    UNDEF(0, "undef", "undef"),
    APPLICATION(1, "application", "application"),
    EXECUTION_PLATFORM(2, "executionPlatform", "executionPlatform"),
    BOTH(3, "both", "both");

    public static final int UNDEF_VALUE = 0;
    public static final int APPLICATION_VALUE = 1;
    public static final int EXECUTION_PLATFORM_VALUE = 2;
    public static final int BOTH_VALUE = 3;
    private static final AllocationEndKind[] VALUES_ARRAY;
    public static final List<AllocationEndKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AllocationEndKind[]{UNDEF, APPLICATION, EXECUTION_PLATFORM, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AllocationEndKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AllocationEndKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AllocationEndKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AllocationEndKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AllocationEndKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEF;
            }
            case 1: {
                return APPLICATION;
            }
            case 2: {
                return EXECUTION_PLATFORM;
            }
            case 3: {
                return BOTH;
            }
        }
        return null;
    }

    private AllocationEndKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

