/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.contract.expression.validation;

import eu.fbk.tools.editor.basetype.baseType.BooleanLiteral;
import eu.fbk.tools.editor.basetype.baseType.Expression;
import eu.fbk.tools.editor.basetype.baseType.InfiniteLiteral;
import eu.fbk.tools.editor.basetype.baseType.IntegerLiteral;
import eu.fbk.tools.editor.basetype.baseType.RealLiteral;
import eu.fbk.tools.editor.contract.expression.expression.AbsFunction;
import eu.fbk.tools.editor.contract.expression.expression.AddSubExpression;
import eu.fbk.tools.editor.contract.expression.expression.BigLogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.Bound;
import eu.fbk.tools.editor.contract.expression.expression.BoundedExpression;
import eu.fbk.tools.editor.contract.expression.expression.ChangeFunction;
import eu.fbk.tools.editor.contract.expression.expression.ConditionalExpression;
import eu.fbk.tools.editor.contract.expression.expression.EqualityExpression;
import eu.fbk.tools.editor.contract.expression.expression.ExpressionPackage;
import eu.fbk.tools.editor.contract.expression.expression.FallRiseFunction;
import eu.fbk.tools.editor.contract.expression.expression.FullPortId;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.Function;
import eu.fbk.tools.editor.contract.expression.expression.IterativeCountFunction;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBound;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.LogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.MulDivExpression;
import eu.fbk.tools.editor.contract.expression.expression.NextFunction;
import eu.fbk.tools.editor.contract.expression.expression.NumericalFunction;
import eu.fbk.tools.editor.contract.expression.expression.RelationalExpression;
import eu.fbk.tools.editor.contract.expression.expression.StutterPortId;
import eu.fbk.tools.editor.contract.expression.expression.TemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.TimeSinceUntilFunction;
import eu.fbk.tools.editor.contract.expression.expression.UnaryAlgebraicExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryLogicalExpression;
import eu.fbk.tools.editor.contract.expression.expression.UnaryTemporalExpression;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.contract.expression.validation.AbstractExpressionValidator;
import eu.fbk.tools.editor.contract.expression.validation.BigOperatorsIndexVariableProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ConnectionIndexVariableProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ContractIDIndexVariableProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.DefineProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.EnumValueProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.IterativeCountFunctionIndexVariableProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ModelUtil;
import eu.fbk.tools.editor.contract.expression.validation.ParameterProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.PortProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ValidatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ExpressionValidator
extends AbstractExpressionValidator {
    public static boolean predicate = false;

    @Check
    public boolean checkIsDeclaredVariable(FullVariableId variable) {
        VariableId _id = variable.getId();
        if (_id instanceof StutterPortId) {
            return true;
        }
        this.populateBigOperatorsIndexVariablesFromFullVariableId(variable);
        this.populateIterativeCountFunctionIndexVariablesFromFullVariableId(variable);
        boolean _isDeclaredVariableCheckEnabled = ValidatorUtil.isDeclaredVariableCheckEnabled();
        if (_isDeclaredVariableCheckEnabled) {
            ArrayList<String> componentIds;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            String variableName = ModelUtil.getVariableIdAsStr(variable.getId());
            PortProposalProvider.PortInfo _get = PortProposalProvider.getInstance().getPorts().get(variableName);
            boolean bl = _tripleNotEquals = _get != null;
            if (_tripleNotEquals) {
                return true;
            }
            ParameterProposalProvider.ParameterInfo _get_1 = ParameterProposalProvider.getInstance().getParameters().get(variableName);
            boolean bl2 = _tripleNotEquals_1 = _get_1 != null;
            if (_tripleNotEquals_1) {
                return true;
            }
            String partialVariableName = ModelUtil.getPartialVariableIdAsStr(variable.getId());
            if (variableName != partialVariableName) {
                boolean _tripleNotEquals_3;
                boolean _tripleNotEquals_2;
                PortProposalProvider.PortInfo _get_2 = PortProposalProvider.getInstance().getPorts().get(partialVariableName);
                boolean bl3 = _tripleNotEquals_2 = _get_2 != null;
                if (_tripleNotEquals_2) {
                    return true;
                }
                ParameterProposalProvider.ParameterInfo _get_3 = ParameterProposalProvider.getInstance().getParameters().get(partialVariableName);
                boolean bl4 = _tripleNotEquals_3 = _get_3 != null;
                if (_tripleNotEquals_3) {
                    return true;
                }
            }
            if ((componentIds = ModelUtil.getAllPossibleComponentIds(variable)) != null && !componentIds.isEmpty()) {
                for (String possibleCompId : componentIds) {
                    boolean _tripleNotEquals_11;
                    boolean _tripleNotEquals_10;
                    boolean _tripleNotEquals_9;
                    boolean _tripleNotEquals_8;
                    boolean _tripleNotEquals_7;
                    boolean _tripleNotEquals_6;
                    boolean _tripleNotEquals_5;
                    boolean _tripleNotEquals_4;
                    String variableNameWithPossibleCompId = String.join((CharSequence)".", possibleCompId, variableName);
                    PortProposalProvider.PortInfo _get_4 = PortProposalProvider.getInstance().getPorts().get(variableNameWithPossibleCompId);
                    boolean bl5 = _tripleNotEquals_4 = _get_4 != null;
                    if (_tripleNotEquals_4) {
                        return true;
                    }
                    PortProposalProvider.PortInfo _get_5 = PortProposalProvider.getInstance().getPorts().get(variableNameWithPossibleCompId);
                    boolean bl6 = _tripleNotEquals_5 = _get_5 != null;
                    if (_tripleNotEquals_5) {
                        return true;
                    }
                    ParameterProposalProvider.ParameterInfo _get_6 = ParameterProposalProvider.getInstance().getParameters().get(variableNameWithPossibleCompId);
                    boolean bl7 = _tripleNotEquals_6 = _get_6 != null;
                    if (_tripleNotEquals_6) {
                        return true;
                    }
                    ParameterProposalProvider.ParameterInfo _get_7 = ParameterProposalProvider.getInstance().getParameters().get(variableNameWithPossibleCompId);
                    boolean bl8 = _tripleNotEquals_7 = _get_7 != null;
                    if (_tripleNotEquals_7) {
                        return true;
                    }
                    List<String> _defines = DefineProposalProvider.getInstance().getDefines();
                    for (String defineName : _defines) {
                        boolean _equals = defineName.equals(variableNameWithPossibleCompId);
                        if (!_equals) continue;
                        return true;
                    }
                    if (variableName == partialVariableName) continue;
                    String partialVariableNameWithPossibleCompId = String.join((CharSequence)".", possibleCompId, partialVariableName);
                    PortProposalProvider.PortInfo _get_8 = PortProposalProvider.getInstance().getPorts().get(partialVariableNameWithPossibleCompId);
                    boolean bl9 = _tripleNotEquals_8 = _get_8 != null;
                    if (_tripleNotEquals_8) {
                        return true;
                    }
                    PortProposalProvider.PortInfo _get_9 = PortProposalProvider.getInstance().getPorts().get(partialVariableNameWithPossibleCompId);
                    boolean bl10 = _tripleNotEquals_9 = _get_9 != null;
                    if (_tripleNotEquals_9) {
                        return true;
                    }
                    ParameterProposalProvider.ParameterInfo _get_10 = ParameterProposalProvider.getInstance().getParameters().get(partialVariableNameWithPossibleCompId);
                    boolean bl11 = _tripleNotEquals_10 = _get_10 != null;
                    if (_tripleNotEquals_10) {
                        return true;
                    }
                    ParameterProposalProvider.ParameterInfo _get_11 = ParameterProposalProvider.getInstance().getParameters().get(partialVariableNameWithPossibleCompId);
                    boolean bl12 = _tripleNotEquals_11 = _get_11 != null;
                    if (_tripleNotEquals_11) {
                        return true;
                    }
                    List<String> _defines_1 = DefineProposalProvider.getInstance().getDefines();
                    for (String defineName_1 : _defines_1) {
                        boolean _equals_1 = defineName_1.equals(partialVariableNameWithPossibleCompId);
                        if (!_equals_1) continue;
                        return true;
                    }
                }
            }
            List<ConnectionIndexVariableProposalProvider.ValueDescriptor> _values = ConnectionIndexVariableProposalProvider.getInstance().getValues();
            for (ConnectionIndexVariableProposalProvider.ValueDescriptor value : _values) {
                boolean _equals = value.indexVariableName.equals(variableName);
                if (!_equals) continue;
                return true;
            }
            List<ContractIDIndexVariableProposalProvider.ValueDescriptor> _values_1 = ContractIDIndexVariableProposalProvider.getInstance().getValues();
            for (ContractIDIndexVariableProposalProvider.ValueDescriptor value_1 : _values_1) {
                boolean _equals_1 = value_1.indexVariableName.equals(variableName);
                if (!_equals_1) continue;
                return true;
            }
            List<BigOperatorsIndexVariableProposalProvider.ValueDescriptor> _values_2 = BigOperatorsIndexVariableProposalProvider.getInstance().getValues();
            for (BigOperatorsIndexVariableProposalProvider.ValueDescriptor value_2 : _values_2) {
                boolean _equals_2 = value_2.indexVariableName.equals(variableName);
                if (!_equals_2) continue;
                return true;
            }
            List<IterativeCountFunctionIndexVariableProposalProvider.ValueDescriptor> _values_3 = IterativeCountFunctionIndexVariableProposalProvider.getInstance().getValues();
            for (IterativeCountFunctionIndexVariableProposalProvider.ValueDescriptor value_3 : _values_3) {
                boolean _equals_3 = value_3.indexVariableName.equals(variableName);
                if (!_equals_3) continue;
                return true;
            }
            List<EnumValueProposalProvider.ValueDescriptor> _values_4 = EnumValueProposalProvider.getInstance().getValues();
            for (EnumValueProposalProvider.ValueDescriptor value_4 : _values_4) {
                boolean _equals_4 = value_4.value.equals(variableName);
                if (!_equals_4) continue;
                return true;
            }
            List<String> _defines = DefineProposalProvider.getInstance().getDefines();
            for (String defineName : _defines) {
                boolean _equals_5 = defineName.equals(variableName);
                if (!_equals_5) continue;
                return true;
            }
            this.error("Invalid symbol " + variableName, variable.getId(), (EStructuralFeature)ExpressionPackage.Literals.VARIABLE_ID__NAME);
            return false;
        }
        return true;
    }

    public void populateBigOperatorsIndexVariablesFromFullVariableId(FullVariableId fullVariableId) {
        if (ModelUtil.belongsToBigLogicalExpression((EObject)fullVariableId) && !ModelUtil.belongsToIteratorBounds((EObject)fullVariableId)) {
            BigLogicalExpression bigLogicalExpression = ModelUtil.getParentBigLogicalExpression((EObject)fullVariableId);
            if (bigLogicalExpression == null) {
                return;
            }
            this.populateBigOperatorsIndexVariables(ModelUtil.getIteratorBoundsFromBigLogicalExpression(bigLogicalExpression));
        } else {
            BigOperatorsIndexVariableProposalProvider.getInstance().clear();
        }
    }

    public void populateIterativeCountFunctionIndexVariablesFromFullVariableId(FullVariableId fullVariableId) {
        if (ModelUtil.belongsToIterativeCountFunction((EObject)fullVariableId) && !ModelUtil.belongsToIteratorBounds((EObject)fullVariableId)) {
            IterativeCountFunction iterativeCountFunction = ModelUtil.getParentIterativeCountFunction((EObject)fullVariableId);
            if (iterativeCountFunction == null) {
                return;
            }
            this.populateIterativeCountFunctionIndexVariables(ModelUtil.getIteratorBoundsFromIterativeCountFunction(iterativeCountFunction));
        } else {
            IterativeCountFunctionIndexVariableProposalProvider.getInstance().clear();
        }
    }

    public void populateConnectionIndexVariables(IteratorBounds iteratorBounds) {
        if (iteratorBounds != null) {
            EList<IteratorBound> _bounds = iteratorBounds.getBounds();
            for (IteratorBound bound : _bounds) {
                ConnectionIndexVariableProposalProvider.getInstance().add(bound.getName());
            }
        }
    }

    public void populateContractIDIndexVariables(IteratorBounds iteratorBounds) {
        if (iteratorBounds != null) {
            EList<IteratorBound> _bounds = iteratorBounds.getBounds();
            for (IteratorBound bound : _bounds) {
                ContractIDIndexVariableProposalProvider.getInstance().add(bound.getName());
            }
        }
    }

    public void populateBigOperatorsIndexVariables(IteratorBounds iteratorBounds) {
        if (iteratorBounds != null) {
            EList<IteratorBound> _bounds = iteratorBounds.getBounds();
            for (IteratorBound bound : _bounds) {
                BigOperatorsIndexVariableProposalProvider.getInstance().add(bound.getName());
            }
        }
    }

    public void populateIterativeCountFunctionIndexVariables(IteratorBounds iteratorBounds) {
        if (iteratorBounds != null) {
            EList<IteratorBound> _bounds = iteratorBounds.getBounds();
            for (IteratorBound bound : _bounds) {
                IterativeCountFunctionIndexVariableProposalProvider.getInstance().add(bound.getName());
            }
        }
    }

    @Check
    public void checkIsBooleanExpression(Expression expression) {
        if (predicate) {
            Optional<Boolean> booleanExpression = this.isBooleanFormula(expression);
            if (expression.eContainer() == null && booleanExpression.isPresent() && !booleanExpression.get().booleanValue()) {
                this.error("Argument should be a boolean formula or boolean literal", (EObject)expression, null);
            }
        }
    }

    @Check
    public void checkIsBooleanAbsFunction(AbsFunction function) {
        Optional<Boolean> argument = this.isBooleanFormula(function.getArgument());
        if (argument.isPresent() && argument.get().booleanValue()) {
            this.error("Argument of absolute function is not a number", (EObject)function, (EStructuralFeature)ExpressionPackage.Literals.ABS_FUNCTION__ARGUMENT);
        }
    }

    @Check
    public void checkIsBooleanFallRiseTemporalFunction(FallRiseFunction function) {
        Optional<Boolean> argument = this.isBooleanFormula(function.getArgument());
        if (argument.isPresent() && !argument.get().booleanValue()) {
            this.error("Argument of fall rise temporal function should be a boolean formula or boolean literal", (EObject)function, (EStructuralFeature)ExpressionPackage.Literals.FALL_RISE_FUNCTION__ARGUMENT);
        }
    }

    @Check
    public void checkIsBooleanLogicalExpression(LogicalExpression expression) {
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left operand of logical expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right operand of logical expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.LOGICAL_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkIsBooleanUnaryLogicalExpression(UnaryLogicalExpression expression) {
        Optional<Boolean> operand = this.isBooleanFormula(expression.getOperand());
        if (operand.isPresent() && !operand.get().booleanValue()) {
            this.error("Operand of unary logical expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.UNARY_LOGICAL_EXPRESSION__OPERAND);
        }
    }

    @Check
    public void checkIsBooleanBigLogicalExpression(BigLogicalExpression expression) {
        Optional<Boolean> operand = this.isBooleanFormula(expression.getOperand());
        if (operand.isPresent() && !operand.get().booleanValue()) {
            this.error("Operand of big logical expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.BIG_LOGICAL_EXPRESSION__OPERAND);
        }
    }

    @Check
    public void checkIsBooleanAddSubExpression(AddSubExpression expression) {
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && left.get().booleanValue()) {
            this.error("Left operand of add sub expression should be a numeric formula or number literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.ADD_SUB_EXPRESSION__LEFT);
        }
        if (right.isPresent() && right.get().booleanValue()) {
            this.error("Right operand of add sub expression should be a numeric formula or number literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.ADD_SUB_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkIsBooleanMulDivExpression(MulDivExpression expression) {
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && left.get().booleanValue()) {
            this.error("Left operand of mul div expression should be a numeric formula or number literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.MUL_DIV_EXPRESSION__LEFT);
        }
        if (right.isPresent() && right.get().booleanValue()) {
            this.error("Right operand of mul div expression should be a numeric formula or number literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.MUL_DIV_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkIsBooleanUnaryAlgebraicExpression(UnaryAlgebraicExpression expression) {
        Optional<Boolean> operand = this.isBooleanFormula(expression.getOperand());
        if (operand.isPresent() && operand.get().booleanValue()) {
            this.error("Operand of unary algebraic expression should be a numeric formula or number literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.UNARY_ALGEBRAIC_EXPRESSION__OPERAND);
        }
    }

    @Check
    public void checkIsBooleanEqualityExpression(EqualityExpression expression) {
        Boolean _get_1;
        boolean _tripleNotEquals;
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (!left.isPresent() || !right.isPresent()) {
            return;
        }
        Boolean _get = left.get();
        boolean bl = _tripleNotEquals = _get != (_get_1 = right.get());
        if (_tripleNotEquals) {
            this.error("Comparison expression operands are of different types", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.EQUALITY_EXPRESSION__LEFT);
            this.error("Comparison expression operands are of different types", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkIsBooleanRelationalExpression(RelationalExpression expression) {
        Boolean _get_1;
        boolean _tripleNotEquals;
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && left.get().booleanValue()) {
            this.error("Left operand of relational expression is boolean", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__LEFT);
        }
        if (right.isPresent() && right.get().booleanValue()) {
            this.error("Right operand of relational expression is boolean", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
        }
        if (!left.isPresent() || !right.isPresent()) {
            return;
        }
        Boolean _get = left.get();
        boolean bl = _tripleNotEquals = _get != (_get_1 = right.get());
        if (_tripleNotEquals) {
            this.error("Comparison expression operands are of different types", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__LEFT);
            this.error("Comparison expression operands are of different types", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
        }
    }

    @Check
    public void checkIsBooleanConditionalExpression(ConditionalExpression expression) {
        Boolean _get_1;
        boolean _tripleNotEquals;
        Optional<Boolean> thenExp = this.isBooleanFormula(expression.getThenStmt());
        Optional<Boolean> elseExp = this.isBooleanFormula(expression.getElseStmt());
        if (!thenExp.isPresent() || !elseExp.isPresent()) {
            return;
        }
        Boolean _get = thenExp.get();
        boolean bl = _tripleNotEquals = _get != (_get_1 = elseExp.get());
        if (_tripleNotEquals) {
            this.error("Expression operands are of different types (i.e. numeric and boolean)", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.CONDITIONAL_EXPRESSION__THEN_STMT);
            this.error("Expression operands are of different types (i.e. numeric and boolean)", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.CONDITIONAL_EXPRESSION__ELSE_STMT);
        }
    }

    @Check
    public void checkIsBooleanUnaryTemporalExpression(UnaryTemporalExpression expression) {
        Optional<Boolean> operand = this.isBooleanFormula(expression.getOperand());
        if (operand.isPresent() && !operand.get().booleanValue()) {
            this.error("Operand of unary temporal expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.UNARY_TEMPORAL_EXPRESSION__OPERAND);
        }
    }

    @Check
    public void checkIsBooleanTemporalExpression(TemporalExpression expression) {
        String operator_nospace = expression.getOp().getName().replaceAll("\\s", "");
        if (operator_nospace.equals("atnext") || operator_nospace.equals("atlast")) {
            return;
        }
        Optional<Boolean> left = this.isBooleanFormula(expression.getLeft());
        Optional<Boolean> right = this.isBooleanFormula(expression.getRight());
        if (left.isPresent() && !left.get().booleanValue()) {
            this.error("Left operand of temporal expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.TEMPORAL_EXPRESSION__LEFT);
        }
        if (right.isPresent() && !right.get().booleanValue()) {
            this.error("Right operand of temporal expression should be a boolean formula or boolean literal", (EObject)expression, (EStructuralFeature)ExpressionPackage.Literals.TEMPORAL_EXPRESSION__RIGHT);
        }
    }

    public Optional<Boolean> isBooleanFormula(Expression expression) {
        if (expression instanceof BoundedExpression) {
            return this.isBooleanFormula(((BoundedExpression)expression).getExpression());
        }
        if (expression instanceof Function) {
            return Optional.empty();
        }
        if (expression instanceof NumericalFunction) {
            return Optional.of(false);
        }
        if (expression instanceof AddSubExpression) {
            return Optional.of(false);
        }
        if (expression instanceof TimeSinceUntilFunction) {
            return Optional.of(false);
        }
        if (expression instanceof NextFunction) {
            return this.isBooleanFormula(((NextFunction)expression).getArgument());
        }
        if (expression instanceof FullVariableId) {
            return this.isBooleanVariable((FullVariableId)expression);
        }
        if (expression instanceof TemporalExpression) {
            TemporalExpression temporalExpression = (TemporalExpression)expression;
            Optional<Boolean> left = this.isBooleanFormula(temporalExpression.getLeft());
            Optional<Boolean> right = this.isBooleanFormula(temporalExpression.getRight());
            if (!left.isPresent() || !right.isPresent()) {
                return Optional.empty();
            }
            if (left.get().booleanValue() && right.get().booleanValue()) {
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        if (expression instanceof UnaryTemporalExpression) {
            return this.isBooleanFormula(((UnaryTemporalExpression)expression).getOperand());
        }
        if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            Optional<Boolean> thenExp = this.isBooleanFormula(conditionalExpression.getThenStmt());
            Optional<Boolean> elseExp = this.isBooleanFormula(conditionalExpression.getElseStmt());
            if (!thenExp.isPresent() || !elseExp.isPresent()) {
                return Optional.empty();
            }
            if (thenExp.get().booleanValue() && elseExp.get().booleanValue()) {
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        if (expression instanceof BigLogicalExpression) {
            return this.isBooleanFormula(((BigLogicalExpression)expression).getOperand());
        }
        if (!(expression instanceof LogicalExpression || expression instanceof UnaryLogicalExpression || expression instanceof EqualityExpression || expression instanceof RelationalExpression || expression instanceof BooleanLiteral || expression instanceof FallRiseFunction || expression instanceof ChangeFunction)) {
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    public Optional<Boolean> isBooleanVariable(FullVariableId variable) {
        this.populateBigOperatorsIndexVariablesFromFullVariableId(variable);
        boolean _isDeclaredVariableCheckEnabled = ValidatorUtil.isDeclaredVariableCheckEnabled();
        if (_isDeclaredVariableCheckEnabled) {
            ArrayList<String> componentIds;
            String variableName = ModelUtil.getVariableIdAsStr(variable.getId());
            PortProposalProvider.PortInfo _get = PortProposalProvider.getInstance().getPorts().get(variableName);
            ProposalProvider.VariableInfo variableInfo = _get;
            if (variableInfo == null) {
                ParameterProposalProvider.ParameterInfo _get_1 = ParameterProposalProvider.getInstance().getParameters().get(variableName);
                variableInfo = _get_1;
            }
            String partialVariableName = ModelUtil.getPartialVariableIdAsStr(variable.getId());
            if (variableInfo == null) {
                PortProposalProvider.PortInfo _get_2;
                variableInfo = _get_2 = PortProposalProvider.getInstance().getPorts().get(partialVariableName);
            }
            if (variableInfo == null) {
                ParameterProposalProvider.ParameterInfo _get_3 = ParameterProposalProvider.getInstance().getParameters().get(partialVariableName);
                variableInfo = _get_3;
            }
            if (variableInfo == null && (componentIds = ModelUtil.getAllPossibleComponentIds(variable)) != null && !componentIds.isEmpty()) {
                for (String possibleCompId : componentIds) {
                    String variableNameWithPossibleCompId = String.join((CharSequence)".", possibleCompId, variableName);
                    variableInfo = PortProposalProvider.getInstance().getPorts().get(variableNameWithPossibleCompId);
                    if (variableInfo == null) {
                        ParameterProposalProvider.ParameterInfo _get_4 = ParameterProposalProvider.getInstance().getParameters().get(variableNameWithPossibleCompId);
                        variableInfo = _get_4;
                    }
                    if (variableName == partialVariableName) continue;
                    String partialVariableNameWithPossibleCompId = String.join((CharSequence)".", possibleCompId, partialVariableName);
                    variableInfo = PortProposalProvider.getInstance().getPorts().get(partialVariableNameWithPossibleCompId);
                    if (variableInfo != null) continue;
                    ParameterProposalProvider.ParameterInfo _get_5 = ParameterProposalProvider.getInstance().getParameters().get(partialVariableNameWithPossibleCompId);
                    variableInfo = _get_5;
                }
            }
            if (variableInfo == null) {
                List<EnumValueProposalProvider.ValueDescriptor> _values = EnumValueProposalProvider.getInstance().getValues();
                for (EnumValueProposalProvider.ValueDescriptor valueDescriptor : _values) {
                    boolean _equals = variableName.equals(valueDescriptor.value);
                    if (!_equals) continue;
                    return Optional.of(false);
                }
            }
            List<String> _defines = DefineProposalProvider.getInstance().getDefines();
            for (String define : _defines) {
                boolean _equals_1 = variableName.equals(define);
                if (!_equals_1) continue;
                return Optional.empty();
            }
            if (variableInfo.type == null) {
                return Optional.of(false);
            }
            if (variableInfo.type == ProposalProvider.VariableType.BOOLEAN) {
                return Optional.of(true);
            }
            if (variableInfo.type == ProposalProvider.VariableType.EVENT) {
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Check
    public boolean checkStutterPort(StutterPortId variableId) {
        if (variableId.eContainer() instanceof FullPortId && ((FullPortId)variableId.eContainer()).getFullComponentIds().isEmpty()) {
            this.error("Stutter of the current component can't be used here", variableId, (EStructuralFeature)ExpressionPackage.Literals.VARIABLE_ID__NAME);
            return false;
        }
        return true;
    }

    @Check
    public boolean checkTemporalBounds(Bound bound) {
        boolean _not;
        Boolean _isNumericalExpression = this.isNumericalExpression(bound.getLower());
        boolean bl = _not = _isNumericalExpression == false;
        if (_not) {
            this.error("Invalid lower bound", bound, (EStructuralFeature)ExpressionPackage.Literals.BOUND__LOWER);
            return false;
        }
        if (!this.isNumericalExpression(bound.getUpper()).booleanValue() && !(bound.getUpper() instanceof InfiniteLiteral)) {
            this.error("Invalid upper bound", bound, (EStructuralFeature)ExpressionPackage.Literals.BOUND__UPPER);
            return false;
        }
        return true;
    }

    public Boolean isNumericalExpression(Expression expression) {
        if (expression instanceof IntegerLiteral) {
            return true;
        }
        if (expression instanceof RealLiteral) {
            return true;
        }
        if (expression instanceof Function) {
            return true;
        }
        if (expression instanceof AddSubExpression) {
            return true;
        }
        if (expression instanceof MulDivExpression) {
            return true;
        }
        if (expression instanceof BoundedExpression) {
            return this.isNumericalExpression(((BoundedExpression)expression).getExpression());
        }
        if (expression instanceof UnaryAlgebraicExpression) {
            return true;
        }
        if (expression instanceof FullVariableId) {
            return true;
        }
        if (expression instanceof NumericalFunction) {
            return true;
        }
        return false;
    }
}

