/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.DropUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class CustomMessageReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject newEnd;
    private final EditPartViewer viewer;

    public CustomMessageReorientCommand(ReorientRelationshipRequest request, EditPartViewer viewer) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.viewer = viewer;
        this.reorientDirection = request.getDirection();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        MessageEnd target;
        EObject source;
        if (!(this.getElementToEdit() instanceof Message)) {
            return false;
        }
        Message message = (Message)this.getElementToEdit();
        if (this.reorientDirection == 1) {
            source = this.newEnd;
            target = message.getReceiveEvent();
        } else {
            source = message.getSendEvent();
            target = this.newEnd;
        }
        MessageSort messageSort = message.getMessageSort();
        MessageKind messageKind = message.getMessageKind();
        return MessageUtils.isValidMessage(messageSort, messageKind, source, (EObject)target);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        boolean reorientSource = this.reorientDirection == 1;
        boolean reorientTarget = this.reorientDirection == 2;
        Message message = (Message)this.getElementToEdit();
        boolean destruction = reorientTarget && message.getMessageSort() == MessageSort.DELETE_MESSAGE_LITERAL;
        boolean creation = reorientTarget && message.getMessageSort() == MessageSort.CREATE_MESSAGE_LITERAL;
        MessageEnd newMessageEnd = MessageUtils.convertToMessageOccurrenceSpecification(this.newEnd, destruction);
        if (reorientSource) {
            message.setSendEvent(newMessageEnd);
        } else if (reorientTarget) {
            message.setReceiveEvent(newMessageEnd);
        }
        if (destruction || creation) {
            Set<View> parentInteractionViews = this.findParentInteractionViews((EObject)newMessageEnd);
            if (destruction) {
                OccurrenceSpecificationUtils.deleteEverythingAfter((OccurrenceSpecification)newMessageEnd, null);
            }
            if (creation) {
                OccurrenceSpecificationUtils.deleteEverythingBefore((OccurrenceSpecification)newMessageEnd, null);
            }
            for (View parentInteractionView : parentInteractionViews) {
                DropUtils.getDropMessageCommand(message, parentInteractionView, this.viewer).execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        return CommandResult.newOKCommandResult((Object)message);
    }

    private Set<View> findParentInteractionViews(EObject eObject) {
        List views = DiagramEditPartsUtil.findViews((EObject)eObject, (EditPartViewer)this.viewer);
        HashSet<View> interactionViews = new HashSet<View>();
        for (View view : views) {
            View interactionView = ViewUtils.findSuperViewWithId(view, "Interaction_Shape");
            if (interactionView == null) continue;
            interactionViews.add(interactionView);
        }
        return interactionViews;
    }
}

