/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFLabelDescription;
import org.eclipse.eef.EEFLabelStyle;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IConsumer;
import org.eclipse.eef.core.api.controllers.IEEFLabelController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.ActionButton;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EEFLabelLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int LABEL_WIDTH_HINT = 300;
    private EEFLabelDescription description;
    private StyledText body;
    private List<ActionButton> actionButtons = new ArrayList<ActionButton>();
    private IEEFLabelController controller;
    private EEFWidgetFactory widgetFactory;

    public EEFLabelLifecycleManager(EEFLabelDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        super(variableManager, interpreter, contextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        Composite labelComposite = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginRight = 5;
        labelComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        labelComposite.setLayoutData((Object)gridData);
        this.createLabel(labelComposite);
        this.createWidgetActionButtons(labelComposite);
        this.controller = new EEFControllersFactory().createLabelController(this.description, this.variableManager, this.interpreter, this.contextAdapter);
    }

    private void createLabel(Composite parent) {
        this.body = this.widgetFactory.createStyledText(parent, 64);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = this.body.getLineHeight();
        gridData.widthHint = 300;
        gridData.horizontalIndent = 5;
        this.body.setLayoutData((Object)gridData);
        this.body.setEditable(false);
    }

    private void createWidgetActionButtons(Composite parent) {
        Composite buttons = this.widgetFactory.createFlatFormComposite(parent);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        buttons.setLayoutData((Object)gridData);
        buttons.setLayout((Layout)new GridLayout(this.description.getActions().size(), true));
        for (EEFWidgetAction action : this.description.getActions()) {
            ActionButton actionButton = new ActionButton(action, buttons, this.widgetFactory, this.interpreter, this.variableManager);
            this.actionButtons.add(actionButton);
        }
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.controller.onNewValue((IConsumer)new IConsumer<String>(){

            public void apply(String value) {
                if (!EEFLabelLifecycleManager.this.body.isDisposed()) {
                    if (EEFLabelLifecycleManager.this.body.getText() == null || !EEFLabelLifecycleManager.this.body.getText().equals(value)) {
                        EEFLabelLifecycleManager.this.body.setText((String)Objects.firstNonNull((Object)value, (Object)""));
                    }
                    EEFLabelLifecycleManager.this.setStyle();
                }
            }
        });
        for (final ActionButton actionButton : this.actionButtons) {
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!EEFLabelLifecycleManager.this.container.isRenderingInProgress()) {
                        IStatus result = EEFLabelLifecycleManager.this.controller.action(actionButton.getAction());
                        if (result != null && result.getSeverity() == 4) {
                            EEFIdeUiPlugin.INSTANCE.log(result);
                        } else {
                            EEFLabelLifecycleManager.this.refresh();
                        }
                    }
                }
            };
            actionButton.addSelectionListener(selectionListener);
        }
    }

    private void setStyle() {
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle style = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (style instanceof EEFLabelStyle) {
            EEFLabelStyle labelStyle = (EEFLabelStyle)style;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.body);
            styleHelper.applyTextStyle(labelStyle.getFontNameExpression(), labelStyle.getFontSizeExpression(), labelStyle.getFontStyleExpression(), this.body.getFont(), labelStyle.getBackgroundColorExpression(), labelStyle.getForegroundColorExpression(), callback);
        }
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.body.isDisposed()) {
            this.body.setEnabled(isEnabled);
        }
        for (ActionButton actionButton : this.actionButtons) {
            if (actionButton.getButton().isDisposed()) continue;
            actionButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        for (ActionButton actionButton : this.actionButtons) {
            actionButton.removeSelectionListener();
        }
        this.controller.removeNewValueConsumer();
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    protected Control getValidationControl() {
        return this.body;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.actionButtons.clear();
    }
}

