/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.factory;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.sysml.diagram.parametric.provider.ElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class DiagramPaletteFactory
extends PaletteFactory.Adapter {
    private static HashMap<String, IElementType[]> nodesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("parametric.tool.blockcomposite", new IElementType[]{SysMLElementTypes.BLOCK});
            this.put("parametric.tool.blockpropertycomposite", new IElementType[]{SysMLElementTypes.PART_PROPERTY});
            this.put("parametric.tool.reference", new IElementType[]{SysMLElementTypes.REFERENCE_PROPERTY});
            this.put("parametric.tool.value", new IElementType[]{SysMLElementTypes.VALUE_PROPERTY});
            this.put("parametric.tool.constraintblockpropertycomposite", new IElementType[]{SysMLElementTypes.CONSTRAINT_PROPERTY});
            this.put("parametric.tool.flowport", new IElementType[]{SysMLElementTypes.FLOW_PORT});
            this.put("parametric.tool.port", new IElementType[]{UMLElementTypes.PORT});
            this.put("parametric.tool.parameter", new IElementType[]{UMLElementTypes.PROPERTY});
            this.put("parametric.tool.constraint", new IElementType[]{UMLElementTypes.CONSTRAINT});
            this.put("parametric.tool.comment", new IElementType[]{UMLElementTypes.COMMENT});
        }
    };
    private static HashMap<String, IElementType[]> edgesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("parametric.tool.connector", new IElementType[]{UMLElementTypes.CONNECTOR});
            this.put("parametric.tool.dependency", new IElementType[]{UMLElementTypes.DEPENDENCY});
            this.put("parametric.tool.comment_constraint_link", new IElementType[]{ElementTypes.COMMENT_ANNOTATED_ELEMENT});
            this.put("parametric.tool.context_link", new IElementType[]{ElementTypes.CONTEXT_LINK});
        }
    };

    public Tool createTool(String toolId) {
        IElementType[] types = nodesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeCreationTool(Arrays.asList(types));
        }
        types = edgesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeConnectionTool(Arrays.asList(types));
        }
        return null;
    }
}

