/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.style;

import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ResetStylePropertiesToDefaultValuesCommand;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class ResetStylePropertiesToDefaultValuesAction
extends Action
implements Disposable {
    public static final String ACTION_NAME = Messages.ResetStylePropertiesToDefaultValuesAction_text;
    public static final String ID = "RESET_STYLE_PROPERTIES_TO_DEFAULT_VALUES_ACTION_ID";
    private IWorkbenchPage page;
    private ISelection selection;

    public ResetStylePropertiesToDefaultValuesAction(IWorkbenchPage page) {
        super(ACTION_NAME);
        this.page = page;
        ImageDescriptor enabledImage = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/undo_edit.gif");
        ImageDescriptor disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        this.setId(ID);
        this.setImageDescriptor(enabledImage);
        this.setDisabledImageDescriptor(disabledImage);
        this.setEnabled(this.isEnabled());
    }

    public boolean isEnabled() {
        boolean result = false;
        IEditorPart activeEditor = this.page.getActiveEditor();
        if (activeEditor instanceof DDiagramEditor) {
            this.selection = activeEditor.getEditorSite().getSelectionProvider().getSelection();
            if (this.selection instanceof StructuredSelection) {
                for (IGraphicalEditPart part : Iterables.filter((Iterable)((StructuredSelection)this.selection).toList(), IGraphicalEditPart.class)) {
                    DDiagramElement dDiagramElement;
                    View view = part.getNotationView();
                    EObject element = view.getElement();
                    if (element instanceof DDiagramElement && this.shouldBeEnable(dDiagramElement = (DDiagramElement)element)) {
                        result = true;
                        break;
                    }
                    ViewQuery viewQuery = new ViewQuery(view);
                    if (!viewQuery.isCustomized()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private boolean shouldBeEnable(DDiagramElement dDiagramElement) {
        IPermissionAuthority permissionAuthority;
        boolean result = false;
        DDiagramElementQuery dDiagramElementQuery = new DDiagramElementQuery(dDiagramElement);
        if (dDiagramElementQuery.isCustomized() && ((permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)dDiagramElement)) == null || permissionAuthority.canEditInstance((EObject)dDiagramElement))) {
            result = true;
        }
        return result;
    }

    public void run() {
        IEditorPart activeEditor = this.page.getActiveEditor();
        if (activeEditor instanceof DDiagramEditor) {
            DDiagramEditor dDiagramEditor = (DDiagramEditor)activeEditor;
            DDiagram dDiagram = (DDiagram)dDiagramEditor.getRepresentation();
            Map<View, DDiagramElement> customizedViews = this.getSelectedCustomizedViews();
            if (!customizedViews.isEmpty()) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dDiagram);
                domain.getCommandStack().execute((Command)new ResetStylePropertiesToDefaultValuesCommand(domain, dDiagram, customizedViews));
            }
        }
    }

    private Map<View, DDiagramElement> getSelectedCustomizedViews() {
        LinkedHashMap<View, DDiagramElement> customizedViews = new LinkedHashMap<View, DDiagramElement>();
        if (this.selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)this.selection;
            for (Object obj : structuredSelection.toList()) {
                View view;
                EObject element;
                if (!(obj instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)obj;
                if (graphicalEditPart instanceof AbstractDEdgeNameEditPart && graphicalEditPart.getParent() instanceof AbstractDiagramEdgeEditPart) {
                    graphicalEditPart = (IGraphicalEditPart)graphicalEditPart.getParent();
                }
                if ((element = (view = graphicalEditPart.getNotationView()).getElement()) instanceof DDiagramElement) {
                    DDiagramElement dDiagramElement = (DDiagramElement)element;
                    if (!new DDiagramElementQuery(dDiagramElement).isCustomized() && !new ViewQuery(view).isCustomized()) continue;
                    customizedViews.put(view, dDiagramElement);
                    continue;
                }
                if (element != null || !new ViewQuery(view).isCustomized()) continue;
                customizedViews.put(view, null);
            }
        }
        return customizedViews;
    }

    public void dispose() {
        this.selection = null;
        this.page = null;
    }
}

