/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.sirius.diagram.BackgroundStyle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientHelper;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IRoundedCorner;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewGradientFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.swt.graphics.Color;

public class GradientRoundedRectangle
extends RoundedRectangle
implements ViewNodeContainerFigureDesc,
ViewGradientFigureDesc,
IRoundedCorner {
    private SiriusWrapLabel fLabelFigure;
    private Color gradientColor;
    private BackgroundStyle backgroundStyle;

    public GradientRoundedRectangle(Dimension dimension, BackgroundStyle backgroundStyle) {
        this.backgroundStyle = backgroundStyle;
        this.setCornerDimensions(new Dimension(MapModeUtil.getMapMode().DPtoLP(dimension.width), MapModeUtil.getMapMode().DPtoLP(dimension.height)));
        this.createBorder();
        this.createContents();
    }

    public GradientRoundedRectangle() {
        this(new Dimension(8, 8), BackgroundStyle.GRADIENT_LEFT_TO_RIGHT_LITERAL);
    }

    public void setGradientColor(Color color) {
        this.gradientColor = color;
    }

    @Override
    public Color getGradientColor() {
        return this.gradientColor;
    }

    protected void createContents() {
        this.fLabelFigure = new SiriusWrapLabel();
        this.fLabelFigure.setText("  ");
        this.fLabelFigure.setTextWrap(true);
        this.add((IFigure)this.fLabelFigure);
    }

    protected void createBorder() {
        this.setBorder((Border)new MarginBorder(5, 0, 0, 0));
    }

    @Override
    public SiriusWrapLabel getLabelFigure() {
        return this.fLabelFigure;
    }

    protected void fillShape(Graphics graphics) {
        if (this.getGradientColor() != null) {
            GradientHelper.setColorsGradation(graphics, this);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
        }
        super.fillShape(graphics);
    }

    @Override
    public BackgroundStyle getBackgroundStyle() {
        return this.backgroundStyle;
    }

    @Override
    public int getCornerHeight() {
        return this.getCornerDimensions().height;
    }

    @Override
    public int getCornerWidth() {
        return this.getCornerDimensions().width;
    }
}

