/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils.dnd;

import java.awt.AWTException;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefFigureCanvas;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;

public class DndUtil {
    private static final int DRAG_THRESHOLD = "gtk".equals(SWT.getPlatform()) ? 16 : 10;
    private static final int DRAG_DELAY = 400;
    private final Display display;

    public DndUtil(Display display) {
        this.display = display;
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target) {
        this.dragAndDrop(source, DndUtil.on(target));
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target, org.eclipse.swt.graphics.Point locationOnTarget) {
        Rectangle targetRectangle = DndUtil.absoluteLocation(target);
        org.eclipse.swt.graphics.Point dropTarget = new org.eclipse.swt.graphics.Point(targetRectangle.x + locationOnTarget.x, targetRectangle.y + locationOnTarget.y);
        this.dragAndDrop(source, dropTarget);
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target, Point locationOnTarget) {
        this.dragAndDrop(source, target, new org.eclipse.swt.graphics.Point(locationOnTarget.x, locationOnTarget.y));
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, org.eclipse.swt.graphics.Point target) {
        Rectangle sourceLocation = DndUtil.absoluteLocation(source);
        org.eclipse.swt.graphics.Point slightOffset = Geometry.add((org.eclipse.swt.graphics.Point)Geometry.getLocation((Rectangle)sourceLocation), (org.eclipse.swt.graphics.Point)new org.eclipse.swt.graphics.Point(DRAG_THRESHOLD, DRAG_THRESHOLD));
        this.doDragAndDrop(Geometry.min((org.eclipse.swt.graphics.Point)Geometry.centerPoint((Rectangle)sourceLocation), (org.eclipse.swt.graphics.Point)slightOffset), target);
    }

    protected void dragAndDrop(org.eclipse.swt.graphics.Point source, AbstractSWTBot<? extends Widget> target) {
        this.doDragAndDrop(source, DndUtil.on(target));
    }

    private void doDragAndDrop(final org.eclipse.swt.graphics.Point source, final org.eclipse.swt.graphics.Point dest) {
        try {
            final Robot awtRobot = new Robot();
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(source.x, source.y);
                    awtRobot.mousePress(16);
                    awtRobot.mouseMove(source.x + DRAG_THRESHOLD, source.y);
                }
            });
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(dest.x + DRAG_THRESHOLD, dest.y);
                    awtRobot.mouseMove(dest.x, dest.y);
                }
            });
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseRelease(16);
                }
            });
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    private void syncExec(VoidResult toExecute) {
        UIThreadRunnable.syncExec((Display)this.display, (VoidResult)toExecute);
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point before(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnUpperBorder(DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point on(AbstractSWTBot<T> targetItem) {
        return Geometry.centerPoint((Rectangle)DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> org.eclipse.swt.graphics.Point after(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnLowerBorder(DndUtil.absoluteLocation(targetItem));
    }

    private static org.eclipse.swt.graphics.Point pointOnLowerBorder(Rectangle rect) {
        return new org.eclipse.swt.graphics.Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + rect.height - 1);
    }

    private static org.eclipse.swt.graphics.Point pointOnUpperBorder(Rectangle rect) {
        return new org.eclipse.swt.graphics.Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + 1);
    }

    private static <T extends Widget> Rectangle absoluteLocation(AbstractSWTBot<T> item) {
        Object bot = null;
        bot = item instanceof SWTBotTreeItem ? new SWTBotTreeItemForDnd((TreeItem)((SWTBotTreeItem)item).widget) : (item instanceof SWTBotGefFigureCanvas ? new SWTBotGefFigureCanvasForDnd((FigureCanvas)((SWTBotGefFigureCanvas)item).widget) : item);
        Object result = null;
        try {
            Method m = AbstractSWTBot.class.getDeclaredMethod("absoluteLocation", new Class[0]);
            m.setAccessible(true);
            result = m.invoke(bot, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return (Rectangle)result;
    }

    public static boolean isUsingXvnc() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") >= 0) {
            String xdisplay = System.getenv("DISPLAY");
            StringBuilder commandBuilder = new StringBuilder();
            commandBuilder.append("/usr/bin/pgrep -l -f ");
            commandBuilder.append("Xvnc.*");
            commandBuilder.append(xdisplay);
            try {
                Process proc = Runtime.getRuntime().exec(commandBuilder.toString());
                proc.waitFor();
                return proc.exitValue() == 0;
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    private static class SWTBotGefFigureCanvasForDnd
    extends SWTBotGefFigureCanvas {
        public SWTBotGefFigureCanvasForDnd(FigureCanvas canvas) throws WidgetNotFoundException {
            super(canvas);
        }

        protected Rectangle absoluteLocation() {
            return (Rectangle)UIThreadRunnable.syncExec((Result)new Result<Rectangle>(){

                public Rectangle run() {
                    return SWTBotGefFigureCanvasForDnd.this.display.map((Control)((Canvas)SWTBotGefFigureCanvasForDnd.this.widget).getParent(), null, ((Canvas)SWTBotGefFigureCanvasForDnd.this.widget).getBounds());
                }
            });
        }
    }

    private static class SWTBotTreeItemForDnd
    extends SWTBotTreeItem {
        public SWTBotTreeItemForDnd(TreeItem treeItem) throws WidgetNotFoundException {
            super(treeItem);
        }

        protected Rectangle absoluteLocation() {
            return (Rectangle)UIThreadRunnable.syncExec((Result)new Result<Rectangle>(){

                public Rectangle run() {
                    return SWTBotTreeItemForDnd.this.display.map((Control)((TreeItem)SWTBotTreeItemForDnd.this.widget).getParent(), null, ((TreeItem)SWTBotTreeItemForDnd.this.widget).getBounds());
                }
            });
        }
    }
}

