/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFPageDescription;
import org.eclipse.eef.EEFPropertyValidationRuleDescription;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.properties.PropertyValidationRule;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.ui.properties.api.DescriptionCache;
import org.eclipse.sirius.ui.properties.api.IDescriptionLinkResolver;

public class PropertyValidationRuleLinkResolver
implements IDescriptionLinkResolver {
    @Override
    public void resolve(EEFViewDescription view, DescriptionCache cache) {
        EList pages = view.getPages();
        for (EEFPageDescription page : pages) {
            EList groups = page.getGroups();
            for (EEFGroupDescription group : groups) {
                EList propertyValidationRules = group.getPropertyValidationRules();
                for (EEFPropertyValidationRuleDescription eefPropertyValidationRule : propertyValidationRules) {
                    this.resolve(eefPropertyValidationRule, cache);
                }
            }
        }
    }

    private void resolve(EEFPropertyValidationRuleDescription eefPropertyValidationRule, DescriptionCache cache) {
        Object siriusDescription = cache.getSiriusDescription(eefPropertyValidationRule);
        if (siriusDescription instanceof PropertyValidationRule) {
            PropertyValidationRule siriusPropertyValidationRule = (PropertyValidationRule)siriusDescription;
            EList widgets = siriusPropertyValidationRule.getTargets();
            for (WidgetDescription siriusWidget : widgets) {
                Object eefDescription = cache.getEEFDescription(siriusWidget);
                if (!(eefDescription instanceof EEFWidgetDescription)) continue;
                eefPropertyValidationRule.getTargets().add((Object)((EEFWidgetDescription)eefDescription));
            }
        }
    }
}

