/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.properties.internal.SiriusContext;

public class SiriusInputDescriptor
implements InputDescriptor {
    private final SiriusContext context;

    public SiriusInputDescriptor(Object input) {
        this.context = SiriusContext.from(input);
    }

    public Object getOriginalSelection() {
        return this.context.getInput();
    }

    public EObject getSemanticElement() {
        Option<EObject> obj = this.context.getMainSemanticElement();
        if (obj.some()) {
            return (EObject)obj.get();
        }
        return null;
    }

    public Collection<EObject> getAllSemanticElements() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.add(this.getSemanticElement());
        Option<Collection<EObject>> additional = this.context.getAdditionalSemanticElements();
        if (additional.some()) {
            result.addAll((Collection)additional.get());
        }
        return result;
    }

    public SiriusContext getFullContext() {
        return this.context;
    }
}

