/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class RepositoryTimeIndication
extends CDOServerIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, RepositoryTimeIndication.class);
    private long indicated;

    public RepositoryTimeIndication(CDOServerProtocol protocol) {
        super(protocol, (short)23);
    }

    public RepositoryTimeIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.indicated = this.getRepository().getTimeStamp();
    }

    protected void responding(CDODataOutput out) throws IOException {
        long responded = this.getRepository().getTimeStamp();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing indicated: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)this.indicated)});
        }
        out.writeLong(this.indicated);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing responded: {0}", new Object[]{CDOCommonUtil.formatTimeStamp((long)responded)});
        }
        out.writeLong(responded);
    }
}

