/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.Arrays;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.ocl.TypeResolver;

final class DefinitionSignature {
    private final String myName;
    private final EClassifier myType;
    private final EClassifier[] myArgs;
    private TypeResolver<EClassifier, EOperation, EStructuralFeature> myTypeResolver;

    public static DefinitionSignature create(ExecutionContext ctx, XpandDefinition def) {
        if (def == null || ctx == null) {
            return null;
        }
        EClassifier type = def.getTargetType().getTypeForName(ctx);
        if (type == null) {
            return null;
        }
        EClassifier[] args = new EClassifier[def.getParams().length];
        int i = 0;
        while (i < def.getParams().length) {
            EClassifier nextArg = def.getParams()[i].getTypeForName(ctx);
            if (nextArg == null) {
                return null;
            }
            args[i] = nextArg;
            ++i;
        }
        return new DefinitionSignature(def.getName(), type, args, (TypeResolver<EClassifier, EOperation, EStructuralFeature>)ctx.getOCLEnvironment().getTypeResolver());
    }

    private DefinitionSignature(String name, EClassifier type, EClassifier[] args, TypeResolver<EClassifier, EOperation, EStructuralFeature> typeResolver) {
        this.myName = name;
        this.myType = type;
        this.myArgs = args;
        this.myTypeResolver = typeResolver;
        assert (this.myName != null);
        assert (this.myArgs != null);
        EClassifier[] eClassifierArray = this.myArgs;
        int n = this.myArgs.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier nextArg = eClassifierArray[n2];
            assert (nextArg != null);
            ++n2;
        }
        assert (this.myTypeResolver != null);
    }

    public boolean equals(Object o) {
        if (o instanceof DefinitionSignature) {
            DefinitionSignature that = (DefinitionSignature)o;
            return this.myName.equals(that.myName) && (this.myType == null && that.myType == null || this.myType.equals(this.resolve(that.myType))) && Arrays.equals(this.myArgs, this.resolve(that.myArgs));
        }
        return false;
    }

    private EClassifier resolve(EClassifier classifier) {
        return (EClassifier)this.myTypeResolver.resolve((Object)classifier);
    }

    private EClassifier[] resolve(EClassifier[] classifiers) {
        EClassifier[] result = new EClassifier[classifiers.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.resolve(classifiers[i]);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }
}

