/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.junit.Assert;

public abstract class AbstractInterpretedExpressionTestCase
extends TestCase {
    private static final String RETURN_TYPE = "http://www.eclipse.org/sirius/interpreted/expression/returnType";
    private static final String VARIABLES = "http://www.eclipse.org/sirius/interpreted/expression/variables";
    private Collection<EAttribute> interpretedExpressions;
    private EPackage basePackage;
    private final Predicate<EAttribute> isInterpretedExpression = new Predicate<EAttribute>(){

        public boolean apply(EAttribute input) {
            return DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(input.getEAttributeType());
        }
    };

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpretedExpressions = Sets.newLinkedHashSet();
        Assert.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
        this.handleEPackage(this.basePackage);
    }

    private void handleEPackage(EPackage pkg) {
        for (EClass eclass : Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class)) {
            this.handleEClass(eclass);
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.handleEPackage(subPkg);
        }
    }

    private void handleEClass(EClass eclass) {
        Iterables.addAll(this.interpretedExpressions, (Iterable)Iterables.filter((Iterable)eclass.getEAttributes(), this.isInterpretedExpression));
    }

    public void testVariableTypesInterpretedExpressionEAnnotation() {
        ArrayListMultimap wrongTypes = ArrayListMultimap.create();
        for (EAttribute attr : this.interpretedExpressions) {
            EAnnotation varAnnotations = attr.getEAnnotation(VARIABLES);
            if (varAnnotations == null) continue;
            for (String varName : varAnnotations.getDetails().keySet()) {
                String typeName;
                String errorMessage;
                String doc = (String)varAnnotations.getDetails().get((Object)varName);
                if (doc == null || doc.indexOf("|") == -1 || (errorMessage = this.validateVariableType(typeName = doc.substring(0, doc.indexOf("|")).trim())) == null) continue;
                wrongTypes.put((Object)attr, (Object)(String.valueOf(varName) + ":" + typeName + " > " + errorMessage));
            }
        }
        Assert.assertTrue((String)this.getMessage((Multimap<EAttribute, String>)wrongTypes), (boolean)wrongTypes.isEmpty());
    }

    private String getMessage(Multimap<EAttribute, String> wrongTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(wrongTypes.size());
        sb.append(" variable(s) available in interpreted expressions need type correction:");
        for (EAttribute attr : wrongTypes.keySet()) {
            sb.append("\n . ");
            sb.append(attr.eResource().getURIFragment((EObject)attr));
            for (String v : wrongTypes.get((Object)attr)) {
                sb.append("\n   . " + v);
            }
        }
        return sb.toString();
    }

    private String validateVariableType(String typeName) {
        String errorMessage = "cannot be checked, the test method must be improved";
        if ("ecore.EObject".equals(typeName) || "EObject".equals(typeName)) {
            errorMessage = null;
        } else {
            EClassifier eClassifier;
            int indexOf = typeName.indexOf(".");
            String pName = typeName.substring(0, indexOf).trim();
            String cName = typeName.substring(indexOf + 1).trim();
            EPackage ePackage = this.getEPackage(pName, this.getAvailablePackages());
            errorMessage = ePackage != null ? ((eClassifier = ePackage.getEClassifier(cName)) == null ? "the EClass " + cName + " has not been found in the indicated EPackage." : null) : "the EPackage" + pName + " might not be accessible for the expression.";
        }
        return errorMessage;
    }

    private Collection<EPackage> getAvailablePackages() {
        LinkedHashSet availablePackages = Sets.newLinkedHashSet();
        availablePackages.add(this.basePackage);
        availablePackages.add(this.getDialectPackage());
        availablePackages.add(ViewpointPackage.eINSTANCE);
        return availablePackages;
    }

    protected EPackage getDialectPackage() {
        return this.getBasePackage();
    }

    private EPackage getEPackage(String pName, Collection<EPackage> packages) {
        EPackage found = null;
        for (EPackage p : packages) {
            found = p.getName().equals(pName) ? p : this.getEPackage(pName, (Collection<EPackage>)p.getESubpackages());
            if (found != null) break;
        }
        return found;
    }

    public void testVariablesInInterpretedExpressionEAnnotation() {
        ArrayList nonDocumented = Lists.newArrayList();
        Predicate<EAttribute> needsDocumentation = new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                EAnnotation eAnnotation = input.getEAnnotation(AbstractInterpretedExpressionTestCase.VARIABLES);
                return eAnnotation == null;
            }
        };
        Iterables.addAll((Collection)nonDocumented, (Iterable)Iterables.filter(this.interpretedExpressions, (Predicate)needsDocumentation));
        nonDocumented.remove(ToolPackage.Literals.ABSTRACT_TOOL_DESCRIPTION__ELEMENTS_TO_SELECT);
        Assert.assertTrue((String)this.getMessage(nonDocumented, VARIABLES), (boolean)nonDocumented.isEmpty());
    }

    public void testReturnTypeInterpretedExpressionEAnnotation() {
        ArrayList nonDocumented = Lists.newArrayList();
        Predicate<EAttribute> needsReturnType = new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                EAnnotation eAnnotation = input.getEAnnotation(AbstractInterpretedExpressionTestCase.RETURN_TYPE);
                return eAnnotation == null || eAnnotation.getDetails().isEmpty();
            }
        };
        Iterables.addAll((Collection)nonDocumented, (Iterable)Iterables.filter(this.interpretedExpressions, (Predicate)needsReturnType));
        Assert.assertTrue((String)this.getMessage(nonDocumented, RETURN_TYPE), (boolean)nonDocumented.isEmpty());
    }

    private String getMessage(List<EAttribute> nonDocumented, String source) {
        StringBuilder sb = new StringBuilder();
        sb.append(nonDocumented.size());
        sb.append(" interpreted expression(s) needs variable EAnnotation ");
        sb.append(source);
        sb.append(": ");
        for (EAttribute attr : nonDocumented) {
            sb.append("\n . ");
            sb.append(attr.eResource().getURIFragment((EObject)attr));
        }
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.interpretedExpressions.clear();
    }

    protected void assertVariableExistence(AbstractToolDescription tool, String expectedVariable, Set<String> variables) {
        AbstractInterpretedExpressionTestCase.assertTrue((String)("The interpreter context for " + tool.getName() + " should contains the variable " + expectedVariable), (boolean)variables.contains(expectedVariable));
    }

    protected void assertVariableExistenceAndType(AbstractToolDescription tool, String expectedVariable, String expectedType, Set<String> variables, Map<String, VariableType> variablesToType) {
        this.assertVariableExistence(tool, expectedVariable, variables);
        AbstractInterpretedExpressionTestCase.assertEquals((String)("The interpreter context for " + tool.eClass().getName() + " has a bad variable type for variable " + expectedVariable), (String)VariableType.fromString((String)expectedType).toString(), (String)variablesToType.get(expectedVariable).toString());
    }
}

