/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.OSSImporter.commands;

import eu.fbk.eclipse.standardtools.utils.ui.commands.AbstractJobCommand;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import eu.fbk.eclipse.standardtools.xtextService.ui.services.RuntimeErrorService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.OSSImporter.commands.ImportDialog;
import org.polarsys.chess.OSSImporter.core.actions.ImportOSSFileAction;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.diagram.ui.services.CHESSDiagramsGeneratorService;
import org.polarsys.chess.diagramsCreator.actions.ShowBDDElementsAction;
import org.polarsys.chess.diagramsCreator.actions.ShowIBDElementsAction;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class ImportOSSFileCommand
extends AbstractJobCommand
implements IHandler {
    private static String pluginID = "org.polarsys.chess.OSSImporter";
    private static final Logger logger = Logger.getLogger(ImportOSSFileCommand.class);
    private static final String DIALOG_TITLE = "OSS parser";
    private static final String IBD = "InternalBlock";
    private static final String BDD = "BlockDefinition";
    final DialogUtil dialogUtil = DialogUtil.getInstance();

    public ImportOSSFileCommand() {
        super("Add content from OSS file");
    }

    private void showImportMessage(List<String> addedElements, List<String> removedElements) {
        final Display defaultDisplay = Display.getDefault();
        ArrayList<String> items = new ArrayList<String>(addedElements.size() + removedElements.size());
        String message = "Import done!";
        if (addedElements.size() > 0 || removedElements.size() > 0) {
            String messageAdded = "Added/modified " + addedElements.size() + " elements";
            String messageRemoved = "Removed " + removedElements.size() + " elements";
            message = String.valueOf(message) + "\n\n\t" + messageAdded + "\n\t" + messageRemoved;
        } else {
            message = String.valueOf(message) + "\n\n\tNo changes from the previous model were found.";
        }
        final String inportOutcome = message;
        for (String added : addedElements) {
            items.add("ADDED " + added);
        }
        for (String removed : removedElements) {
            items.add("REMOVED " + removed);
        }
        if (items != null && items.size() > 0) {
            final MultiStatus info = new MultiStatus(pluginID, 1, "Click on \"Details\" to see the list of changes.", null);
            for (String item : items) {
                info.add((IStatus)new Status(1, pluginID, 1, item, null));
            }
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    ImportDialog.openError(currShell, ImportOSSFileCommand.DIALOG_TITLE, inportOutcome, (IStatus)info);
                }
            });
        } else {
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    MessageDialog.openInformation((Shell)currShell, (String)"Info", (String)inportOutcome);
                }
            });
        }
    }

    private void showDiagramMessage(Set<String> modifiedDiagrams) {
        final Display defaultDisplay = Display.getDefault();
        if (modifiedDiagrams != null && modifiedDiagrams.size() > 0) {
            final MultiStatus info = new MultiStatus(pluginID, 1, "Click on \"Details\" to see the list of modified/removed diagrams.", null);
            for (String item : modifiedDiagrams) {
                info.add((IStatus)new Status(1, pluginID, 1, item, null));
            }
            defaultDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell currShell = defaultDisplay.getActiveShell();
                    ImportDialog.openError(currShell, ImportOSSFileCommand.DIALOG_TITLE, "Diagrams updated!", (IStatus)info);
                }
            });
        } else {
            this.dialogUtil.showMessage_GenericMessage(DIALOG_TITLE, "\nNo diagrams needed changes");
        }
    }

    public void execPreJobOperations(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        Resource resource;
        Object umlPackage;
        EntityUtil entityUtil = EntityUtil.getInstance();
        SelectionUtil selectionUtil = SelectionUtil.getInstance();
        String packageURI = event.getParameter("packageURI");
        String ossFilePath = event.getParameter("ossFilePath");
        logger.debug((Object)("packageURI: " + packageURI));
        logger.debug((Object)("ossFilePath: " + ossFilePath));
        if (packageURI == null) {
            umlPackage = selectionUtil.getUmlSelectedObject(event);
            resource = selectionUtil.getSelectedUmlModel().getResource();
        } else {
            Resource modelRes = SelectionUtil.getInstance().getSelectedModelResource();
            Model model = (Model)modelRes.getContents().get(0);
            umlPackage = (Package)EntityUtil.getInstance().getElement(model, packageURI);
            logger.debug((Object)("umlPackage: " + umlPackage));
            resource = ((Package)umlPackage).eResource();
        }
        if (entityUtil.isSystemViewPackage((Element)umlPackage)) {
            File ossFile = ossFilePath != null ? new File(ossFilePath) : this.getOSSFileFromDialog();
            if (ossFile != null) {
                boolean isValid = RuntimeErrorService.getInstance().showOSSRuntimeErrors(ossFile, resource, true, false, monitor);
                monitor.beginTask("Importing elements from OSS file", 1);
                ImportOSSFileAction action = ImportOSSFileAction.getInstance();
                if (isValid && action != null) {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.setEditorAreaVisible(false);
                    EntityUtil.getInstance().getCurrentSystemView();
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)umlPackage);
                    StringBuffer importErrors = action.startParsing((Package)umlPackage, ossFile, domain);
                    if (importErrors.length() != 0) {
                        this.dialogUtil.showMessage_GenericMessage(DIALOG_TITLE, importErrors.toString());
                    }
                    activePage.setEditorAreaVisible(true);
                    List<String> addedElements = action.getAddedElements();
                    List<String> removedElements = action.getRemovedElements();
                    this.showImportMessage(addedElements, removedElements);
                    Set<String> modifiedDiagrams = action.getModifiedDiagrams();
                    modifiedDiagrams.addAll(this.updateDiagrams((Package)umlPackage));
                    this.showDiagramMessage(modifiedDiagrams);
                }
            }
            monitor.done();
            return;
        }
        this.dialogUtil.showMessage_GenericMessage(DIALOG_TITLE, "Please select a package from <<SystemView>>");
    }

    public void execJobCommand(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
    }

    private Set<String> updateDiagrams(Package pkg) {
        HashSet<String> modifiedDiagrams = new HashSet<String>();
        CHESSDiagramsGeneratorService chessDiagramsGeneratorService = CHESSDiagramsGeneratorService.getInstance();
        Collection chessDiagrams = chessDiagramsGeneratorService.getDiagrams();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        for (Diagram diagram : chessDiagrams) {
            DiagramEditPart diagramEP;
            Package activePackage = null;
            EObject diagramElement = diagram.getElement();
            if (diagramElement instanceof Package) {
                activePackage = (Package)diagramElement;
            } else if (diagramElement instanceof Class) {
                activePackage = ((Class)diagramElement).getPackage();
            }
            if (activePackage != pkg) continue;
            if (diagram.getType().equals(BDD)) {
                diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
                if (!ShowBDDElementsAction.getInstance().refreshDiagram((IGraphicalEditPart)diagramEP)) continue;
                modifiedDiagrams.add(diagram.getName());
                continue;
            }
            if (!diagram.getType().equals(IBD)) continue;
            diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(diagram, shell);
            if (!ShowIBDElementsAction.getInstance().refreshDiagram((IGraphicalEditPart)diagramEP)) continue;
            modifiedDiagrams.add(diagram.getName());
        }
        return modifiedDiagrams;
    }

    private File getOSSFileFromDialog() throws Exception {
        File ossFile = null;
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.oss", "*.OSS"});
        String result = dialog.open();
        if (result != null) {
            try {
                ossFile = new File(result);
            }
            catch (NullPointerException nullPointerException) {
                throw new Exception("File not valid!");
            }
        }
        return ossFile;
    }

    public void execPostJobOperations(ExecutionEvent event, NullProgressMonitor nullProgressMonitor) throws Exception {
    }
}

