/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.SequenceDiagramPlugin;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalRangeFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceNodeQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentationElement;

public class SequenceMessageViewQuery {
    private final Edge edge;

    public SequenceMessageViewQuery(Edge edge) {
        Preconditions.checkArgument((boolean)Message.notationPredicate().apply((Object)edge));
        this.edge = edge;
    }

    public boolean isReflective() {
        Option<Node> optSource = this.getSourceLifeline();
        Option<Node> optTarget = this.getTargetLifeline();
        return optSource.some() && optTarget.some() && optSource.get() == optTarget.get();
    }

    public Option<Node> getSourceLifeline() {
        Option<Lifeline> lifeline;
        Option result = Options.newNone();
        View source = this.edge.getSource();
        Option<ISequenceElement> iSequenceElement = ISequenceElementAccessor.getISequenceElement(source);
        if (iSequenceElement.some() && (lifeline = ((ISequenceElement)iSequenceElement.get()).getLifeline()).some()) {
            result = Options.newSome((Object)((Lifeline)lifeline.get()).getNotationNode());
        }
        return result;
    }

    public Option<Node> getTargetLifeline() {
        Option<Lifeline> lifeline;
        Option result = Options.newNone();
        View target = this.edge.getTarget();
        Option<ISequenceElement> iSequenceElement = ISequenceElementAccessor.getISequenceElement(target);
        if (iSequenceElement.some() && (lifeline = ((ISequenceElement)iSequenceElement.get()).getLifeline()).some()) {
            result = Options.newSome((Object)((Lifeline)lifeline.get()).getNotationNode());
        }
        return result;
    }

    public Range getVerticalRange() {
        Range result;
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.edge.getBendpoints();
        if (bendpoints == null || bendpoints.getPoints().isEmpty()) {
            result = Range.emptyRange();
        } else {
            int firstY = this.getFirstPointVerticalPosition(true);
            if (this.isLogicallyInstantaneous()) {
                if (this.validateFirstPointStability(firstY)) {
                    result = new Range(firstY, firstY);
                } else {
                    int lastY = this.getLastPointVerticalPosition(false);
                    result = new Range(lastY, lastY);
                }
            } else {
                int lastY = this.getLastPointVerticalPosition(false);
                if (this.msgToSelfInvalidEndLocation(this.edge.getSource(), this.edge.getTarget())) {
                    firstY = VerticalRangeFunction.INSTANCE.apply(this.edge.getSource()).getUpperBound();
                    lastY = firstY + 10;
                }
                result = new Range(Math.min(firstY, lastY), Math.max(firstY, lastY));
            }
        }
        return result;
    }

    public Range getVerticalRange(boolean source) {
        Range result;
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.edge.getBendpoints();
        if (bendpoints == null || bendpoints.getPoints().isEmpty()) {
            result = Range.emptyRange();
        } else {
            int firstY = this.getFirstPointVerticalPosition(source);
            int lastY = this.getLastPointVerticalPosition(source);
            result = new Range(Math.min(firstY, lastY), Math.max(firstY, lastY));
        }
        return result;
    }

    private boolean validateFirstPointStability(int firstY) {
        return true;
    }

    public int getFirstPointVerticalPosition(boolean source) {
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.edge.getBendpoints();
        RelativeBendpoint firstPoint = (RelativeBendpoint)bendpoints.getPoints().get(0);
        return this.getPointVerticalPosition(firstPoint, source);
    }

    private boolean msgToSelfInvalidEndLocation(View end, View otherEnd) {
        return false;
    }

    public int getLastPointVerticalPosition(boolean source) {
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.edge.getBendpoints();
        RelativeBendpoint lastPoint = (RelativeBendpoint)bendpoints.getPoints().get(bendpoints.getPoints().size() - 1);
        return this.getPointVerticalPosition(lastPoint, source);
    }

    public int getPointVerticalPosition(RelativeBendpoint bendpoint, boolean source) {
        int verticalPosition = 0;
        if (!source) {
            int tgtRefY = this.getTargetAnchorVerticalPosition();
            verticalPosition = tgtRefY + bendpoint.getTargetY();
        } else {
            int srcRefY = this.getSourceAnchorVerticalPosition();
            verticalPosition = srcRefY + bendpoint.getSourceY();
        }
        return verticalPosition;
    }

    public int getSourceAnchorVerticalPosition() {
        IdentityAnchor srcAnchor = null;
        Anchor sourceAnchor = this.edge.getSourceAnchor();
        if (sourceAnchor != null && sourceAnchor.eIsProxy()) {
            SequenceDiagramPlugin.INSTANCE.log(MessageFormat.format(Messages.ProxyAnchor_Source, ((DEdge)this.edge.getElement()).getName(), new DRepresentationElementQuery((DRepresentationElement)((DEdge)this.edge.getElement())).getParentRepresentation().getName()));
        } else if (sourceAnchor instanceof IdentityAnchor) {
            srcAnchor = (IdentityAnchor)sourceAnchor;
        }
        View source = this.edge.getSource();
        Range sourceRange = new Range(0, 0);
        if (source instanceof Node) {
            sourceRange = new SequenceNodeQuery((Node)source).getVerticalRange();
        }
        return this.getAnchorAbsolutePosition(srcAnchor, sourceRange);
    }

    public int getTargetAnchorVerticalPosition() {
        IdentityAnchor tgtAnchor = null;
        Anchor targetAnchor = this.edge.getTargetAnchor();
        if (targetAnchor != null && targetAnchor.eIsProxy()) {
            SequenceDiagramPlugin.INSTANCE.log(MessageFormat.format(Messages.ProxyAnchor_Target, ((DEdge)this.edge.getElement()).getName(), new DRepresentationElementQuery((DRepresentationElement)((DEdge)this.edge.getElement())).getParentRepresentation().getName()));
        } else if (targetAnchor instanceof IdentityAnchor) {
            tgtAnchor = (IdentityAnchor)targetAnchor;
        }
        View target = this.edge.getTarget();
        if (target instanceof Node) {
            Range targetRange = new SequenceNodeQuery((Node)target).getVerticalRange();
            return this.getAnchorAbsolutePosition(tgtAnchor, targetRange);
        }
        return this.getSourceAnchorVerticalPosition();
    }

    private int getAnchorAbsolutePosition(IdentityAnchor anchor, Range range) {
        double relY = anchor != null ? this.parseRelY(anchor.getId()) : 0.5;
        return range.getLowerBound() + (int)Math.round(relY * (double)range.width());
    }

    private double parseRelY(String terminal) {
        try {
            return Float.parseFloat(terminal.substring(terminal.indexOf(44) + 1, terminal.indexOf(41)));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    private boolean isLogicallyInstantaneous() {
        return !this.isReflective();
    }
}

