/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.oss.validation;

import eu.fbk.tools.editor.basetype.baseType.BooleanType;
import eu.fbk.tools.editor.basetype.baseType.BoundedArrayType;
import eu.fbk.tools.editor.basetype.baseType.ContinuousType;
import eu.fbk.tools.editor.basetype.baseType.EnumType;
import eu.fbk.tools.editor.basetype.baseType.EventType;
import eu.fbk.tools.editor.basetype.baseType.FixedSizeArrayType;
import eu.fbk.tools.editor.basetype.baseType.Identifier;
import eu.fbk.tools.editor.basetype.baseType.SimpleType;
import eu.fbk.tools.editor.contract.expression.expression.ExpressionPackage;
import eu.fbk.tools.editor.contract.expression.expression.FullVariableId;
import eu.fbk.tools.editor.contract.expression.expression.StutterPortId;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.contract.expression.validation.DefineProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.EnumValueProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ParameterProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.PortProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ProposalProvider;
import eu.fbk.tools.editor.contract.validation.AssertionProposalProvider;
import eu.fbk.tools.editor.contract.validation.ValidatorUtil;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Assertion;
import eu.fbk.tools.editor.oss.oss.ComplexType;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Consistency;
import eu.fbk.tools.editor.oss.oss.Define;
import eu.fbk.tools.editor.oss.oss.Entailment;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.InputPort;
import eu.fbk.tools.editor.oss.oss.InterfaceInstance;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.OpParameter;
import eu.fbk.tools.editor.oss.oss.Operation;
import eu.fbk.tools.editor.oss.oss.OssPackage;
import eu.fbk.tools.editor.oss.oss.OutputPort;
import eu.fbk.tools.editor.oss.oss.Parameter;
import eu.fbk.tools.editor.oss.oss.ParameterizedArrayType;
import eu.fbk.tools.editor.oss.oss.Port;
import eu.fbk.tools.editor.oss.oss.Possibility;
import eu.fbk.tools.editor.oss.oss.Refinement;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SubComponentType;
import eu.fbk.tools.editor.oss.oss.Variable;
import eu.fbk.tools.editor.oss.validation.AbstractOssValidator;
import eu.fbk.tools.editor.oss.validation.ModelUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class OssValidator
extends AbstractOssValidator {
    @Check
    public void checkSubComponent(SubComponent subComponent) {
        AbstractComponent componentType = ModelUtil.getParentComponentType(subComponent);
        if (componentType == null || componentType.getType() == null) {
            return;
        }
        boolean _equals = subComponent.getType().equals(componentType.getType());
        if (_equals) {
            SubComponentType _type = subComponent.getType();
            String _plus = "Invalid subcomponent type " + _type;
            this.error(_plus, subComponent, (EStructuralFeature)OssPackage.Literals.SUB_COMPONENT__TYPE);
        }
    }

    @Check
    public boolean checkIsDeclaredVariable(FullVariableId variableId) {
        this.setupVariableValidation((EObject)variableId);
        boolean _skipEntailment = this.skipEntailment(variableId);
        if (_skipEntailment) {
            return true;
        }
        return super.checkIsDeclaredVariable(variableId);
    }

    public boolean callSuperCheckIsDeclaredVariable(FullVariableId variableId) {
        return super.checkIsDeclaredVariable(variableId);
    }

    @Check
    public Optional<Boolean> isBooleanVariable(FullVariableId variable) {
        Optional _xblockexpression = null;
        this.setupVariableValidation((EObject)variable);
        _xblockexpression = super.isBooleanVariable(variable);
        return _xblockexpression;
    }

    @Check
    public void checkConsistency(Consistency consistencyProp) {
    }

    @Check
    public void checkPossibility(Possibility possibilityProp) {
    }

    @Check
    public void checkEntailment(Entailment entailmentProp) {
    }

    public boolean skipEntailment(FullVariableId fullVariableId) {
        return ModelUtil.belongsToEntailment((EObject)fullVariableId);
    }

    public void setupVariableValidation(EObject fullVariableId) {
        AbstractComponent componentType = ModelUtil.getParentComponentType(fullVariableId);
        if (componentType == null) {
            return;
        }
        ValidatorUtil.clearObjectsProposals();
        this.populateVariables(componentType);
        this.populateAssertions(componentType);
        boolean _belongsToContract = ModelUtil.belongsToContract(fullVariableId);
        if (_belongsToContract) {
            this.populateOperations(componentType, true);
        } else {
            boolean _belongsToRefinementInstance = ModelUtil.belongsToRefinementInstance(fullVariableId);
            if (_belongsToRefinementInstance) {
                this.populateOperations(componentType, false);
                OSS ossNode = ModelUtil.getRoot(fullVariableId);
                if (ossNode != null) {
                    ArrayList<String> _arrayList = new ArrayList<String>();
                    this.populateSubComponentsVariables(ossNode, componentType, _arrayList);
                }
                if (ModelUtil.belongsToConnection(fullVariableId) && !ModelUtil.belongsToIteratorCondition(fullVariableId)) {
                    Connection connection = ModelUtil.getParentConnection(fullVariableId);
                    if (connection == null) {
                        return;
                    }
                    this.populateConnectionIndexVariables(ModelUtil.getIteratorBoundsFromConnection(connection));
                }
                if (ModelUtil.belongsToFullContractIdList(fullVariableId) && !eu.fbk.tools.editor.contract.expression.validation.ModelUtil.belongsToIteratorBounds((EObject)fullVariableId)) {
                    FullContractIdList fullContractIdList = ModelUtil.getParentFullContractIdList(fullVariableId);
                    if (fullContractIdList == null) {
                        return;
                    }
                    this.populateContractIDIndexVariables(ModelUtil.getIteratorBoundsFromFullContractIdList(fullContractIdList));
                }
            }
        }
    }

    public void populateVariables(AbstractComponent component) {
        this.populateVariables(component, null);
    }

    public void populateEnumTypeVariables(String variableName, SimpleType simpleType) {
        block5: {
            SimpleType _type_2;
            block6: {
                block4: {
                    if (!(simpleType instanceof EnumType)) break block4;
                    EList _values = ((EnumType)simpleType).getValues();
                    for (EObject enum_ : _values) {
                        if (!(enum_ instanceof Identifier)) continue;
                        EnumValueProposalProvider.getInstance().add(variableName, ((Identifier)enum_).getValue());
                    }
                    break block5;
                }
                if (!(simpleType instanceof FixedSizeArrayType)) break block6;
                SimpleType _type = ((FixedSizeArrayType)simpleType).getType();
                if (!(_type instanceof EnumType)) break block5;
                SimpleType _type_1 = ((FixedSizeArrayType)simpleType).getType();
                EList _values_1 = ((EnumType)_type_1).getValues();
                for (EObject enum__1 : _values_1) {
                    if (!(enum__1 instanceof Identifier)) continue;
                    EnumValueProposalProvider.getInstance().add(variableName, ((Identifier)enum__1).getValue());
                }
                break block5;
            }
            if (simpleType instanceof BoundedArrayType && (_type_2 = ((BoundedArrayType)simpleType).getType()) instanceof EnumType) {
                SimpleType _type_3 = ((BoundedArrayType)simpleType).getType();
                EList _values_2 = ((EnumType)_type_3).getValues();
                for (EObject enum__2 : _values_2) {
                    if (!(enum__2 instanceof Identifier)) continue;
                    EnumValueProposalProvider.getInstance().add(variableName, ((Identifier)enum__2).getValue());
                }
            }
        }
    }

    public void populateVariables(AbstractComponent component, String prefix) {
        EList<InterfaceInstance> _interfaces = component.getInterface().getInterfaces();
        for (InterfaceInstance interface_ : _interfaces) {
            Define _define;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Variable _variable = interface_.getVariable();
            boolean bl = _tripleNotEquals = _variable != null;
            if (_tripleNotEquals) {
                Variable _variable_1;
                Variable variable = _variable_1 = interface_.getVariable();
                String variableId = ModelUtil.getVariableIdAsStr(interface_.getVariable().getId());
                String _xifexpression = null;
                _xifexpression = prefix == null || prefix.isEmpty() ? variableId : String.valueOf(prefix) + "." + variableId;
                String variableName = _xifexpression;
                SimpleType simpleType = this.getSimpleTypeFromVariable(variable);
                ProposalProvider.VariableType type = this.getVariableTypeFromSimpleType(simpleType);
                this.populateEnumTypeVariables(variableName, simpleType);
                this.populatePortOrParameter(variableName, variable, type);
            }
            boolean bl2 = _tripleNotEquals_1 = (_define = interface_.getDefine()) != null;
            if (!_tripleNotEquals_1) continue;
            String _xifexpression_1 = null;
            if (prefix == null || prefix.isEmpty()) {
                _xifexpression_1 = interface_.getDefine().getName();
            } else {
                String _name = interface_.getDefine().getName();
                _xifexpression_1 = String.valueOf(prefix) + "." + _name;
            }
            String define = _xifexpression_1;
            DefineProposalProvider.getInstance().add(define);
        }
    }

    private void populatePortOrParameter(String variableName, Variable variable, ProposalProvider.VariableType type) {
        if (variable instanceof InputPort) {
            PortProposalProvider.PortInfo info = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.IN, type);
            PortProposalProvider.getInstance().addPort(variableName, info);
        } else if (variable instanceof OutputPort) {
            PortProposalProvider.PortInfo info_1 = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.OUT, type);
            PortProposalProvider.getInstance().addPort(variableName, info_1);
        } else if (variable instanceof Parameter) {
            ArrayList _arrayList = new ArrayList();
            ParameterProposalProvider.ParameterInfo info_2 = new ParameterProposalProvider.ParameterInfo(type, _arrayList);
            EList<ComplexType> _parameters = ((Parameter)variable).getParameters();
            Iterator iterator = _parameters.iterator();
            while (iterator.hasNext()) {
                ComplexType cfr_ignored_0 = (ComplexType)iterator.next();
            }
            ParameterProposalProvider.getInstance().addParameter(variableName, info_2);
        }
    }

    private SimpleType getSimpleTypeFromVariable(Variable variable) {
        if (variable instanceof Port) {
            return this.getSimpleTypeFromComplexType(this.getComplexType((Port)variable));
        }
        if (variable instanceof Parameter) {
            return this.getSimpleTypeFromComplexType(this.getComplexType((Parameter)variable));
        }
        if (variable instanceof Operation) {
            return ((Operation)variable).getType();
        }
        return null;
    }

    private SimpleType getSimpleTypeFromComplexType(ComplexType type) {
        EObject _complexType = type.getComplexType();
        if (_complexType instanceof ParameterizedArrayType) {
            EObject _complexType_1 = type.getComplexType();
            return ((ParameterizedArrayType)_complexType_1).getType();
        }
        EObject _complexType_2 = type.getComplexType();
        return (SimpleType)_complexType_2;
    }

    private ComplexType getComplexType(Port port) {
        return port.getType();
    }

    private ComplexType getComplexType(Parameter parameter) {
        return parameter.getType();
    }

    private ProposalProvider.VariableType getVariableTypeFromSimpleType(SimpleType type) {
        if (type instanceof EventType) {
            return ProposalProvider.VariableType.EVENT;
        }
        if (type instanceof BooleanType) {
            return ProposalProvider.VariableType.BOOLEAN;
        }
        if (type instanceof ContinuousType) {
            return ProposalProvider.VariableType.CONTINUOUS;
        }
        if (type instanceof EnumType) {
            return ProposalProvider.VariableType.ENUM;
        }
        if (type instanceof FixedSizeArrayType) {
            FixedSizeArrayType arrayType = (FixedSizeArrayType)type;
            return this.getVariableTypeFromSimpleType(arrayType.getType());
        }
        if (type instanceof BoundedArrayType) {
            BoundedArrayType arrayType_1 = (BoundedArrayType)type;
            return this.getVariableTypeFromSimpleType(arrayType_1.getType());
        }
        return ProposalProvider.VariableType.NUMBER;
    }

    public void populateAssertions(AbstractComponent component) {
        EList<InterfaceInstance> _interfaces = component.getInterface().getInterfaces();
        for (InterfaceInstance interface_ : _interfaces) {
            Assertion assertion;
            boolean _tripleNotEquals;
            Assertion _assertion = interface_.getAssertion();
            boolean bl = _tripleNotEquals = _assertion != null;
            if (!_tripleNotEquals || !((assertion = interface_.getAssertion()) instanceof Assertion)) continue;
            AssertionProposalProvider.getInstance().add(assertion.getName());
        }
    }

    public void populateOperations(AbstractComponent component, boolean isContract) {
        this.populateOperations(component, null, isContract);
    }

    public void populateOperations(AbstractComponent component, String prefix, boolean isContract) {
        EList<InterfaceInstance> _interfaces = component.getInterface().getInterfaces();
        for (InterfaceInstance interface_ : _interfaces) {
            Variable variable;
            boolean _tripleNotEquals;
            Variable _variable = interface_.getVariable();
            boolean bl = _tripleNotEquals = _variable != null;
            if (!_tripleNotEquals || !((variable = interface_.getVariable()) instanceof Operation)) continue;
            VariableId _id = ((Operation)variable).getId();
            String variableId = ModelUtil.getVariableIdAsStr(_id);
            String _xifexpression = null;
            _xifexpression = prefix == null || prefix.isEmpty() ? variableId : String.valueOf(prefix) + "." + variableId;
            String proposal = _xifexpression;
            if (isContract) {
                PortProposalProvider _instance = PortProposalProvider.getInstance();
                PortProposalProvider.PortInfo _portInfo = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.IN, null);
                _instance.addPort(String.valueOf(proposal) + "_call", _portInfo);
                PortProposalProvider _instance_1 = PortProposalProvider.getInstance();
                PortProposalProvider.PortInfo _portInfo_1 = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.OUT, null);
                _instance_1.addPort(String.valueOf(proposal) + "_ret", _portInfo_1);
                PortProposalProvider _instance_2 = PortProposalProvider.getInstance();
                PortProposalProvider.PortInfo _portInfo_2 = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.OUT, null);
                _instance_2.addPort(String.valueOf(proposal) + "_ret_value", _portInfo_2);
                EList<OpParameter> _opParameters = ((Operation)variable).getOpParameters();
                for (OpParameter opParameter : _opParameters) {
                    PortProposalProvider _instance_3 = PortProposalProvider.getInstance();
                    String _name = opParameter.getName();
                    String _plus = String.valueOf(proposal) + "_" + _name;
                    String _plus_1 = String.valueOf(_plus) + "_param";
                    PortProposalProvider.PortInfo _portInfo_3 = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.IN, null);
                    _instance_3.addPort(_plus_1, _portInfo_3);
                }
                continue;
            }
            PortProposalProvider _instance_4 = PortProposalProvider.getInstance();
            PortProposalProvider.PortInfo _portInfo_4 = new PortProposalProvider.PortInfo(PortProposalProvider.PortDirection.IN_OUT, null);
            _instance_4.addPort(proposal, _portInfo_4);
        }
    }

    public void populateSubComponentsVariables(OSS oss, AbstractComponent componentType, List<String> parentComponentNames) {
        List<SubComponent> subComponents = ModelUtil.getSubComponents(componentType);
        if (subComponents == null || subComponents.isEmpty()) {
            return;
        }
        for (SubComponent subComponent : subComponents) {
            String _xifexpression = null;
            String _componentTypeName = subComponent.getType().getComponentTypeName();
            boolean _tripleNotEquals = _componentTypeName != null;
            _xifexpression = _tripleNotEquals ? subComponent.getType().getComponentTypeName() : subComponent.getType().getArrayComponentTypeName();
            String subComponentTypeStr = _xifexpression;
            AbstractComponent subComponentType = ModelUtil.getComponentType(oss, subComponentTypeStr);
            if (subComponentType == null) continue;
            if (subComponentType.getType() != null && ModelUtil.isChildComponent(subComponentType, componentType)) {
                SubComponentType _type = subComponent.getType();
                String _plus = "Invalid subcomponent type " + _type;
                this.error(_plus, subComponent, (EStructuralFeature)OssPackage.Literals.SUB_COMPONENT__TYPE);
                return;
            }
            String subCompNameAsStr = ModelUtil.getSubCompIdAsStr(subComponent.getName());
            parentComponentNames.add(subCompNameAsStr);
            String parentComponentNamesAsStr = String.join((CharSequence)".", parentComponentNames);
            this.populateVariables(subComponentType, parentComponentNamesAsStr);
            this.populateOperations(subComponentType, parentComponentNamesAsStr, false);
            this.populateSubComponentsVariables(oss, subComponentType, parentComponentNames);
            parentComponentNames.remove(subCompNameAsStr);
        }
    }

    public boolean checkStutterPort(StutterPortId variableId) {
        boolean _tripleNotEquals;
        boolean _not;
        Refinement refinement = (Refinement)EcoreUtil2.getContainerOfType((EObject)variableId, Refinement.class);
        boolean bl = _not = refinement == null || refinement.getType() == null || !refinement.getType().equalsIgnoreCase("ASYNC");
        if (_not) {
            this.error("Stutter can be used only in asynchronous refinement", (EObject)variableId, (EStructuralFeature)ExpressionPackage.Literals.VARIABLE_ID__NAME);
            return false;
        }
        Connection _containerOfType = (Connection)EcoreUtil2.getContainerOfType((EObject)variableId, Connection.class);
        boolean bl2 = _tripleNotEquals = _containerOfType != null;
        if (_tripleNotEquals) {
            this.error("Stutter can't be used in connection", (EObject)variableId, (EStructuralFeature)ExpressionPackage.Literals.VARIABLE_ID__NAME);
            return false;
        }
        return super.checkStutterPort(variableId);
    }
}

