-----------------------------------------------------------------------
--           This file was automatically generated by the            --
--                                                                   --
--                Ada infrastructural code generator                 -- 
--                  for the CHESS component model                    --
--                                                                   --
--                   Copyright (C) 2011-2012                         --
--                 University of Padova, ITALY                       --
--                                                                   --
-- Author: Marco Panunzio         panunzio@math.unipd.it             --
--                                                                   --
-- All rights reserved. This program and the accompanying materials  --
-- are made available under the terms of the Eclipse Public License  --
-- v1.0 which accompanies this distribution, and is available at     --
-- http://www.eclipse.org/legal/epl-v10.html                         --
-----------------------------------------------------------------------

-- Comment the with below if you do not use user-defined datatypes
with Datatype; use Datatype;

-- with of interface and component implementation packages
with Consumer_IF;
with Store_IF;
with Consumers.Consumer_impls;

--with of packages for enforcement of extra-functional properties
with System;
with Ada.Real_Time; use Ada.Real_Time;
with Data_Structure;


package CT_SwSystem_Consumer_insts is 
 
   procedure Initialize_Container;

   -- Getter subprograms for provided interfaces
   function Get_Consumer_IF return Consumer_IF.Consumer_IF_ptr;
 

   -- Setter subprograms for required interfaces
   procedure Set_Store_IF_RI (ptr : in Store_IF.Store_IF_ptr);

private
   
   -- Component instance
   SwSystem_Consumer_inst: aliased Consumers.Consumer_impls.Consumer_impl;
   -- Access pointers to the instance (1 x PI)
   SwSystem_Consumer_inst_as_Consumer_IF_ptr : Consumer_IF.Consumer_IF_ptr := SwSystem_Consumer_inst'access;
   
   -- Type definition for the container
   type CT_SwSystem_Consumer_inst_T is new Consumer_IF.Consumer_IF with null record;

   -- Overriding of operations of interfaces

   overriding 
   procedure Consume (Self: in out CT_SwSystem_Consumer_inst_T;
                          f : in Float);

   -- Instantiation of the container
   CT_SwSystem_Consumer_inst_T_inst_0 : aliased CT_SwSystem_Consumer_inst_T;
   


   -- Entities for the enforcement of extra-functional properties --
   -- Configuration parameters for all queues and OBCS
   Param_Queue_Size : constant Integer := 3;
   OBCS_Queue_Size : constant Integer := Param_Queue_Size * 2;

   -- Instantiation of queues and OBCS
   Consume_OBCS_Ceiling : System.Priority := 4;

   type Consume_Param_T is new Data_Structure.Param_Type with record
      OPCS_Instance : Consumer_IF.Consumer_IF_ptr;
      f : Float;
   end record;
   type Consume_Param_T_Ref is access all Consume_Param_T;

   type Consume_Param_Arr is array(Integer range <>) of aliased Consume_Param_T;

   overriding
   procedure My_OPCS(Self : in out Consume_Param_T);

   -- create an OBCS that matches the interface of the OPCS
   protected type Consume_OBCS(Ceiling : System.Any_Priority;
                       Consume_Params_Arr_Ref_P : Data_Structure.Param_Arr_Ref) is
      pragma Priority(Ceiling);
      entry Get_Request(Req : out Data_Structure.Request_Descriptor_T;
                        Release : out Time);

      -- Subprograms
      procedure Consume (f : in Float);

   private
      -- The queue system for Consume_OBCS
      Consume_OBCS_Queue : Data_Structure.Request_Queue(OBCS_Queue_Size);
      -- Arrays to store a set of reified invocations for Consume
      Consume_Params : Data_Structure.Param_Buffer_T(Param_Queue_Size) :=
        (Size => Param_Queue_Size, Index => 1, Buffer => Consume_Params_Arr_Ref_P.all);
      Pending : Standard.Boolean := False;
   end Consume_OBCS;

end CT_SwSystem_Consumer_insts;
