/*
 * Copyright (c) 2009-2012 Eike Stepper (Berlin, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.examples.company;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Category</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.emf.cdo.examples.company.Category#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.emf.cdo.examples.company.Category#getCategories <em>Categories</em>}</li>
 * <li>{@link org.eclipse.emf.cdo.examples.company.Category#getProducts <em>Products</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.emf.cdo.examples.company.CompanyPackage#getCategory()
 * @model
 * @generated
 */
public interface Category extends EObject
{
  /**
   * Returns the value of the '<em><b>Name</b></em>' attribute. <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Name</em>' attribute isn't clear, there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * 
   * @return the value of the '<em>Name</em>' attribute.
   * @see #setName(String)
   * @see org.eclipse.emf.cdo.examples.company.CompanyPackage#getCategory_Name()
   * @model annotation="teneo.jpa value='@Id @GeneratedValue(generator=\"system-uuid\")'"
   * @generated
   */
  String getName();

  /**
   * Sets the value of the '{@link org.eclipse.emf.cdo.examples.company.Category#getName <em>Name</em>}' attribute. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @param value
   *          the new value of the '<em>Name</em>' attribute.
   * @see #getName()
   * @generated
   */
  void setName(String value);

  /**
   * Returns the value of the '<em><b>Categories</b></em>' containment reference list. The list contents are of type
   * {@link org.eclipse.emf.cdo.examples.company.Category}. <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Categories</em>' containment reference list isn't clear, there really should be more of
   * a description here...
   * </p>
   * <!-- end-user-doc -->
   * 
   * @return the value of the '<em>Categories</em>' containment reference list.
   * @see org.eclipse.emf.cdo.examples.company.CompanyPackage#getCategory_Categories()
   * @model containment="true"
   * @generated
   */
  EList<Category> getCategories();

  /**
   * Returns the value of the '<em><b>Products</b></em>' containment reference list. The list contents are of type
   * {@link org.eclipse.emf.cdo.examples.company.Product}. <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Products</em>' containment reference list isn't clear, there really should be more of a
   * description here...
   * </p>
   * <!-- end-user-doc -->
   * 
   * @return the value of the '<em>Products</em>' containment reference list.
   * @see org.eclipse.emf.cdo.examples.company.CompanyPackage#getCategory_Products()
   * @model containment="true"
   * @generated
   */
  EList<Product> getProducts();

} // Category
