/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views.commands;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.core.internal.extensionpoint.AddProfileHandler;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.profiles.MARTEProfileManager;
import org.polarsys.chess.core.profiles.SysMLProfileManager;
import org.polarsys.chess.core.util.uml.ResourceUtils;

public class CreateViewsCommand
extends RecordingCommand {
    private ModelSet modelSet;

    public CreateViewsCommand(ModelSet rs) {
        super(rs.getTransactionalEditingDomain());
        this.modelSet = rs;
    }

    protected void doExecute() {
        Model currentModel = null;
        if (this.modelSet != null) {
            currentModel = ResourceUtils.getModel(UmlUtils.getUmlModel((ModelSet)this.modelSet).getResource());
            new CHESSProfileManager((ResourceSet)this.modelSet);
        }
        CreateViewsCommand.viewsToModel(currentModel, this.modelSet);
    }

    public static void viewsToModel(Model currentModel, ModelSet mset) {
        CHESSProfileManager.createModel(currentModel);
        MARTEProfileManager.createModel(currentModel);
        SysMLProfileManager.createModel(currentModel);
        AddProfileHandler h = new AddProfileHandler();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        h.executeAddProfile(reg, currentModel, (ResourceSet)mset);
    }
}

