/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.itemis.xtext.utils.jface.viewers.ContextElementAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.yakindu.base.expressions.expressions.ElementReferenceExpression;
import org.yakindu.base.expressions.expressions.FeatureCall;
import org.yakindu.base.types.Operation;
import org.yakindu.base.types.TypesPackage;
import org.yakindu.sct.model.stext.services.STextGrammarAccess;
import org.yakindu.sct.model.stext.stext.InterfaceScope;
import org.yakindu.sct.model.stext.stext.InternalScope;
import org.yakindu.sct.model.stext.stext.SimpleScope;
import org.yakindu.sct.model.stext.stext.StatechartSpecification;
import org.yakindu.sct.model.stext.stext.TransitionSpecification;
import org.yakindu.sct.model.stext.stext.VariableDefinition;
import org.yakindu.sct.model.stext.ui.contentassist.AbstractSTextProposalProvider;

public class STextProposalProvider
extends AbstractSTextProposalProvider {
    @Inject
    private STextGrammarAccess grammarAccess;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        ElementReferenceExpression referenceExpression;
        FeatureCall featureCall;
        ArrayList<Keyword> suppressKeywords = new ArrayList<Keyword>();
        if (contentAssistContext.getRootModel() instanceof TransitionSpecification) {
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getEntryEventAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitEventAccess().getGroup().eContents()));
        } else if (contentAssistContext.getRootModel() instanceof SimpleScope) {
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getVariableDefinitionAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getEventDefinitionAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getDirectionAccess().getAlternatives().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getOperationDefinitionAccess().getGroup().eContents()));
        } else if (contentAssistContext.getRootModel() instanceof StatechartSpecification) {
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getExitEventAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getEntryEventAccess().getGroup().eContents()));
            if (!this.atLeastOnePackageExistsInIndex(this.getSctResource(contentAssistContext.getRootModel()))) {
                suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getImportScopeAccess().getGroup().eContents()));
            }
        }
        EObject currentModel = contentAssistContext.getCurrentModel();
        if (currentModel instanceof InterfaceScope) {
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getLocalReactionAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getAlwaysEventAccess().getGroup().eContents()));
            suppressKeywords.addAll(this.getKeywords((EList<EObject>)this.grammarAccess.getTimeEventTypeAccess().getAlternatives().eContents()));
            suppressKeywords.add(this.grammarAccess.getDirectionAccess().getLOCALLocalKeyword_0_0());
        }
        if (currentModel instanceof FeatureCall && !((featureCall = (FeatureCall)currentModel).getFeature() instanceof Operation)) {
            suppressKeywords.add(this.grammarAccess.getFeatureCallAccess().getOperationCallLeftParenthesisKeyword_1_3_0_0());
        }
        if (currentModel instanceof ElementReferenceExpression && !((referenceExpression = (ElementReferenceExpression)currentModel).getReference() instanceof Operation)) {
            suppressKeywords.add(this.grammarAccess.getElementReferenceExpressionAccess().getOperationCallLeftParenthesisKeyword_2_0_0());
        }
        if (currentModel instanceof InternalScope) {
            suppressKeywords.add(this.grammarAccess.getDirectionAccess().getINInKeyword_1_0());
            suppressKeywords.add(this.grammarAccess.getDirectionAccess().getOUTOutKeyword_2_0());
        }
        if (!suppressKeywords.contains(keyword)) {
            super.completeKeyword(keyword, contentAssistContext, (ICompletionProposalAcceptor)new AcceptorDelegate(acceptor));
        }
    }

    private List<Keyword> getKeywords(EList<EObject> list) {
        ArrayList<Keyword> keywords = new ArrayList<Keyword>();
        for (EObject eObject : list) {
            if (eObject instanceof Keyword) {
                keywords.add((Keyword)eObject);
                continue;
            }
            if (!(eObject instanceof EnumLiteralDeclaration)) continue;
            keywords.add(((EnumLiteralDeclaration)eObject).getLiteral());
        }
        return keywords;
    }

    public void complete_BOOL(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "boolean", acceptor);
        String[] stringArray = new String[]{"true", "false", "yes", "no"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ICompletionProposal proposal = this.createCompletionProposal(s, String.valueOf(s) + " - " + ruleCall.getRule().getName(), null, context);
            priorityOptimizer.accept(proposal);
            ++n2;
        }
    }

    protected ICompletionProposalAcceptor getCustomAcceptor(EObject model, String typeName, ICompletionProposalAcceptor acceptor) {
        VariableDefinition vd;
        Object priorityOptimizer = acceptor;
        if (model instanceof VariableDefinition && (vd = (VariableDefinition)model).getType() != null && typeName.equalsIgnoreCase(vd.getType().getName())) {
            priorityOptimizer = new ICompletionProposalAcceptor.Delegate(acceptor){

                public void accept(ICompletionProposal proposal) {
                    STextProposalProvider.this.alterPriority(proposal, 1);
                    super.accept(proposal);
                }
            };
        }
        return priorityOptimizer;
    }

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_STRING(model, ruleCall, context, this.getCustomAcceptor(model, "string", acceptor));
    }

    public void complete_INT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_INT(model, ruleCall, context, this.getCustomAcceptor(model, "integer", acceptor));
    }

    @Override
    public void complete_XID(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.complete_ID(model, ruleCall, context, acceptor);
    }

    public void complete_HEX(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "integer", acceptor);
        String proposalText = "0x1";
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, String.valueOf(proposalText) + " - " + ruleCall.getRule().getName(), null, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal configurable = (ConfigurableCompletionProposal)proposal;
            configurable.setSelectionStart(configurable.getReplacementOffset() + 2);
            configurable.setSelectionLength(proposalText.length() - 2);
            configurable.setAutoInsertable(false);
            configurable.setSimpleLinkedMode(context.getViewer(), new char[]{'\t', ' '});
        }
        priorityOptimizer.accept(proposal);
    }

    public void complete_DOUBLE(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposalAcceptor priorityOptimizer = this.getCustomAcceptor(model, "real", acceptor);
        String proposalText = "0.1";
        ICompletionProposal proposal = this.createCompletionProposal(proposalText, String.valueOf(proposalText) + " - " + ruleCall.getRule().getName(), null, context);
        priorityOptimizer.accept(proposal);
    }

    private void alterPriority(ICompletionProposal proposal, int delta) {
        if (proposal == null || !(proposal instanceof ConfigurableCompletionProposal)) {
            return;
        }
        ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
        castedProposal.setPriority(castedProposal.getPriority() + delta);
    }

    private boolean atLeastOnePackageExistsInIndex(Resource res) {
        IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(res);
        URI uri = res.getURI();
        IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(uri);
        for (IContainer container : this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions)) {
            Iterable currentDescriptions = container.getResourceDescriptions();
            for (IResourceDescription resDesc : currentDescriptions) {
                Iterable visisblePackages = resDesc.getExportedObjectsByType(TypesPackage.Literals.PACKAGE);
                if (Iterables.isEmpty((Iterable)visisblePackages)) continue;
                return true;
            }
        }
        return false;
    }

    private Resource getSctResource(EObject context) {
        ContextElementAdapter provider = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)context.eResource(), ContextElementAdapter.class);
        if (provider == null) {
            return context.eResource();
        }
        return provider.getElement().eResource();
    }

    public class AcceptorDelegate
    implements ICompletionProposalAcceptor {
        private final ICompletionProposalAcceptor delegate;

        public AcceptorDelegate(ICompletionProposalAcceptor delegate) {
            this.delegate = delegate;
        }

        public void accept(ICompletionProposal proposal) {
            if (proposal instanceof ConfigurableCompletionProposal) {
                Keyword keyword = XtextFactory.eINSTANCE.createKeyword();
                keyword.setValue(proposal.getDisplayString());
                ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)keyword);
                ((ConfigurableCompletionProposal)proposal).setHover(STextProposalProvider.this.getHover());
            }
            this.delegate.accept(proposal);
        }

        public boolean canAcceptMoreProposals() {
            return this.delegate.canAcceptMoreProposals();
        }
    }
}

