/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultErrorHandler
implements ErrorHandler {
    protected List<XSDDiagnostic> xsdDiagnostics = new ArrayList<XSDDiagnostic>();
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;

    @Override
    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    @Override
    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    @Override
    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public Collection<XSDDiagnostic> getDiagnostics() {
        return this.xsdDiagnostics;
    }
}

