/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.CommentCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ComponentCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ConstraintCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.DefaultNamedElementCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.DependencyNodeCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.InterfaceCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.ModelCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.PackageCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.commands.RectangleInterfaceCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLElementTypes;

public class ComponentDiagramItemSemanticEditPolicy
extends UMLBaseItemSemanticEditPolicy {
    public ComponentDiagramItemSemanticEditPolicy() {
        super(UMLElementTypes.Package_1000);
    }

    @Override
    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType requestElementType = req.getElementType();
        if (requestElementType == null) {
            return super.getCreateCommand(req);
        }
        if (UMLElementTypes.Dependency_3203 == requestElementType) {
            return this.getGEFWrapper((ICommand)new DependencyNodeCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Component_2002 == requestElementType) {
            return this.getGEFWrapper((ICommand)new ComponentCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Model_3202 == requestElementType) {
            return this.getGEFWrapper((ICommand)new ModelCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Package_3200 == requestElementType) {
            return this.getGEFWrapper((ICommand)new PackageCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Interface_3205 == requestElementType) {
            return this.getGEFWrapper((ICommand)new RectangleInterfaceCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Comment_3201 == requestElementType) {
            return this.getGEFWrapper((ICommand)new CommentCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Constraint_3199 == requestElementType) {
            return this.getGEFWrapper((ICommand)new ConstraintCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.NamedElement_3204 == requestElementType) {
            return this.getGEFWrapper((ICommand)new DefaultNamedElementCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        if (UMLElementTypes.Interface_2003 == requestElementType) {
            return this.getGEFWrapper((ICommand)new InterfaceCreateCommand(req, DiagramUtils.getDiagramFrom((EditPart)this.getHost())));
        }
        return super.getCreateCommand(req);
    }

    @Override
    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return this.getGEFWrapper((ICommand)new DuplicateAnythingCommand(editingDomain, req));
    }

    private static class DuplicateAnythingCommand
    extends DuplicateEObjectsCommand {
        public DuplicateAnythingCommand(TransactionalEditingDomain editingDomain, DuplicateElementsRequest req) {
            super(editingDomain, req.getLabel(), req.getElementsToBeDuplicated(), req.getAllDuplicatedElementsMap());
        }
    }
}

