/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.edit.policies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.command.CustomConnectorCreateCommand;
import org.eclipse.papyrus.uml.diagram.component.edit.policies.PortItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.providers.UMLElementTypes;

public class CustomPortItemSemanticEditPolicy
extends PortItemSemanticEditPolicy {
    @Override
    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        switch (this.getVisualID((IEditCommandRequest)req)) {
            case 4019: {
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)req.getRelationship());
                if (provider == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                View targetView = (View)this.getHost().getModel();
                req.setParameter("RECONNECT_END_VIEW", (Object)targetView);
                ICommand reorientCommand = provider.getEditCommand((IEditCommandRequest)req);
                if (reorientCommand == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                return this.getGEFWrapper(reorientCommand.reduce());
            }
        }
        return super.getReorientRelationshipCommand(req);
    }

    @Override
    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        EObject semanticParent;
        EObject graphicalParent = ((GraphicalEditPart)this.getHost().getParent()).resolveSemanticElement();
        if (graphicalParent != (semanticParent = req.getElementToDestroy().eContainer())) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDestroyElementCommand(req);
    }

    @Override
    protected Command getStartCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (UMLElementTypes.Connector_4019 == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CustomConnectorCreateCommand(req, req.getSource(), null));
        }
        return super.getStartCreateRelationshipCommand(req);
    }

    @Override
    protected Command getCompleteCreateRelationshipCommand(CreateRelationshipRequest req) {
        if (UMLElementTypes.Connector_4019 == req.getElementType()) {
            return this.getGEFWrapper((ICommand)new CustomConnectorCreateCommand(req, req.getSource(), req.getTarget()));
        }
        return super.getCompleteCreateRelationshipCommand(req);
    }
}

