/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.accessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.CompositeMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtensionFeatureDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.IMetamodelExtender;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ecore.extender.business.internal.permission.PermissionService;
import org.eclipse.sirius.ext.emf.EReferencePredicate;

public class ModelAccessor {
    CompositeMetamodelExtender extender;
    IPermissionAuthority authority = PermissionService.createDefaultPermissionAuthority();
    private boolean silentMode;

    public ModelAccessor() {
        this.extender = new CompositeMetamodelExtender();
        this.extender.activate();
    }

    public void activateMetamodels(Collection<? extends MetamodelDescriptor> mmDescriptors) {
        this.extender.updateMetamodels(mmDescriptors);
    }

    public void init(ResourceSet set) {
        this.extender.init(set);
        this.authority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(set);
    }

    public IPermissionAuthority getPermissionAuthority() {
        return this.authority;
    }

    public void addExtender(IMetamodelExtender newExtender, int priority) {
        this.extender.add(newExtender, priority);
    }

    public EObject createInstance(String name) throws MetaClassNotFoundException {
        EObject value = this.extender.createInstance(name);
        if (value != null) {
            this.authority.notifyNewInstanceCreation(value);
            return value;
        }
        throw new MetaClassNotFoundException(name);
    }

    public boolean eIsKnownType(String name) {
        return this.extender.eIsKnownType(name);
    }

    public boolean eValid(EObject object, String name) {
        return this.extender.eValid(object, name);
    }

    public Object eGet(EObject instance, String name) throws FeatureNotFoundException {
        if (!this.eValid(instance, name)) {
            throw new FeatureNotFoundException();
        }
        return this.extender.eGet(instance, name);
    }

    public Object eSet(EObject instance, String name, Object value) throws FeatureNotFoundException, LockedInstanceException {
        if (this.authority.canEditFeature(instance, name)) {
            Object feedback = null;
            feedback = !this.eIsMany(instance, name) ? this.extender.eSet(instance, name, value) : this.extender.eAdd(instance, name, value);
            if (feedback == null) {
                throw new FeatureNotFoundException(name);
            }
            this.authority.notifyInstanceChange(instance);
            return feedback;
        }
        if (!this.silentMode) {
            throw new LockedInstanceException(instance);
        }
        return null;
    }

    public void eAdd(EObject instance, String name, Object value) throws FeatureNotFoundException, LockedInstanceException {
        if (this.authority.canEditFeature(instance, name)) {
            Object result = null;
            if (value instanceof EObject) {
                if (this.authority.canEditInstance((EObject)value)) {
                    result = this.extender.eAdd(instance, name, value);
                }
            } else {
                result = this.extender.eAdd(instance, name, value);
            }
            if (result == null) {
                throw new FeatureNotFoundException(name);
            }
            this.authority.notifyInstanceChange(instance);
        } else if (!this.silentMode) {
            throw new LockedInstanceException(instance);
        }
    }

    public void eClear(EObject instance, String name) throws LockedInstanceException {
        if (this.authority.canEditFeature(instance, name)) {
            Object value = this.extender.eClear(instance, name);
            if (value != null) {
                this.authority.notifyInstanceChange(instance);
            }
        } else if (!this.silentMode) {
            throw new LockedInstanceException(instance);
        }
    }

    public Object eRemove(EObject instance, String name, Object value) throws LockedInstanceException {
        if (this.authority.canEditFeature(instance, name)) {
            Object result = this.extender.eRemove(instance, name, value);
            if (result != null) {
                this.authority.notifyInstanceChange(instance);
            }
            return result;
        }
        if (!this.silentMode) {
            throw new LockedInstanceException(instance);
        }
        return null;
    }

    public boolean eIsMany(EObject instance, String featureName) throws FeatureNotFoundException {
        Boolean result = this.extender.eIsMany(instance, featureName);
        if (result != null) {
            return result;
        }
        throw new FeatureNotFoundException(String.valueOf(featureName) + " on " + instance);
    }

    public boolean eIsContainment(EObject instance, String featureName) throws FeatureNotFoundException {
        Boolean result = this.extender.eIsContainment(instance, featureName);
        if (result != null) {
            return result;
        }
        throw new FeatureNotFoundException(featureName);
    }

    public EObject eContainer(EObject instance) {
        return this.extender.eContainer(instance);
    }

    public boolean eInstanceOf(EObject instance, String typeName) {
        return this.extender.eInstanceOf(instance, typeName);
    }

    public TreeIterator<EObject> eAllContents(EObject root) {
        return this.extender.eAllContents(root);
    }

    public void eRemove(EObject objectToRemove) {
        String featureName;
        Object value;
        EObject container;
        if (this.authority.canDeleteInstance(objectToRemove) && (container = this.extender.eContainer(objectToRemove)) != null && this.authority.canEditInstance(container) && (value = this.extender.eRemove(container, featureName = this.extender.eContainingFeatureName(objectToRemove), objectToRemove)) != null) {
            this.authority.notifyInstanceDeletion(objectToRemove);
        }
    }

    public void eDelete(EObject objectToRemove, ECrossReferenceAdapter xref) {
        this.eDelete(objectToRemove, xref, null);
    }

    public void eDelete(EObject objectToRemove, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        this.eDelete(objectToRemove, xref, isReferencesToIgnorePredicate, true);
    }

    private void eDelete(EObject objectToRemove, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate, boolean simpleRemoveShouldBePerformedIfDanglingReferenceIsNotChangeable) {
        ECrossReferenceAdapter effectiveXRef = xref == null ? ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)objectToRemove) : xref;
        boolean authorityAllowsDeletion = false;
        boolean allFeaturesAreChangeable = true;
        if (this.authority.canDeleteInstance(objectToRemove)) {
            EObject container = this.extender.eContainer(objectToRemove);
            if (container == null) {
                authorityAllowsDeletion = true;
            } else if (this.authority.canEditInstance(container)) {
                allFeaturesAreChangeable = this.allReferencesCanBeEdited(objectToRemove, effectiveXRef, isReferencesToIgnorePredicate);
                authorityAllowsDeletion = true;
            }
        }
        if (authorityAllowsDeletion) {
            if (allFeaturesAreChangeable || !allFeaturesAreChangeable && !simpleRemoveShouldBePerformedIfDanglingReferenceIsNotChangeable) {
                EObject deletedElement = this.extender.eDelete(objectToRemove, effectiveXRef, isReferencesToIgnorePredicate);
                if (deletedElement != null) {
                    this.authority.notifyInstanceDeletion(objectToRemove);
                }
            } else {
                this.eRemove(objectToRemove);
            }
        } else {
            throw new LockedInstanceException(objectToRemove);
        }
    }

    private boolean allReferencesCanBeEdited(EObject target, ECrossReferenceAdapter xref, EReferencePredicate isReferencesToIgnorePredicate) {
        boolean allReferencesCanBeEdited = true;
        if (xref != null) {
            Collection refs = xref.getInverseReferences(target, true);
            for (EStructuralFeature.Setting setting : refs) {
                boolean isFeatureToIgnore;
                EObject eObj = setting.getEObject();
                EStructuralFeature feature = setting.getEStructuralFeature();
                boolean bl = isFeatureToIgnore = isReferencesToIgnorePredicate != null && feature instanceof EReference && isReferencesToIgnorePredicate.apply((EReference)feature);
                if (isFeatureToIgnore) continue;
                boolean bl2 = allReferencesCanBeEdited = allReferencesCanBeEdited && (feature.isChangeable() || !feature.isDerived());
                if (this.authority.canEditFeature(eObj, feature.getName())) continue;
                throw new LockedInstanceException(eObj);
            }
        }
        return allReferencesCanBeEdited;
    }

    public boolean isExtension(EObject next) {
        return this.extender.isExtension(next);
    }

    public boolean isExtension(EObject next, String name) {
        return this.extender.isExtension(next, name);
    }

    public boolean hasExtension(EObject next) {
        return this.extender.hasExtension(next);
    }

    public Iterator<String> getAllAttributesName(EObject instance) {
        return this.extender.getContributedAttributeNames(instance);
    }

    public Iterator<String> getAllReferencesName(EObject instance) {
        return this.extender.getContributedReferenceNames(instance);
    }

    public Iterator<String> getAllExtendedAttributesName(EObject instance) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> it = this.extender.getContributedAttributeNames(instance);
        while (it.hasNext()) {
            String name = it.next();
            if (!this.extender.isExtension(instance, name)) continue;
            result.add(name);
        }
        return result.iterator();
    }

    public Iterator<String> getAllExtendedReferencesName(EObject instance) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> it = this.extender.getContributedReferenceNames(instance);
        while (it.hasNext()) {
            String name = it.next();
            if (!this.extender.isExtension(instance, name)) continue;
            result.add(name);
        }
        return result.iterator();
    }

    public Collection<EObject> eAllContents(EObject root, String typeName) {
        return this.extender.eAllContents(root, typeName);
    }

    public String getQualifiedName(EObject element, boolean useTypeWhenNoName) {
        return this.extender.getQualifiedName(element, useTypeWhenNoName);
    }

    public Collection<ExtensionFeatureDescription> getAllExtensionFeatureDescriptions(EObject target) {
        return this.extender.getAllExtensionFeatureDescriptions(target);
    }

    public void enableSilentMode(boolean silent) {
        this.silentMode = silent;
    }

    public void dispose() {
        this.extender.dispose();
    }
}

