/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooldef;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StandardToolKind implements Enumerator
{
    SELECT_LITERAL(0, "SELECT", "SELECT"),
    SELECT_PAN_LITERAL(1, "SELECT_PAN", "SELECT_PAN"),
    MARQUEE_LITERAL(2, "MARQUEE", "MARQUEE"),
    ZOOM_PAN_LITERAL(3, "ZOOM_PAN", "ZOOM_PAN"),
    ZOOM_IN_LITERAL(4, "ZOOM_IN", "ZOOM_IN"),
    ZOOM_OUT_LITERAL(5, "ZOOM_OUT", "ZOOM_OUT");

    public static final int SELECT = 0;
    public static final int SELECT_PAN = 1;
    public static final int MARQUEE = 2;
    public static final int ZOOM_PAN = 3;
    public static final int ZOOM_IN = 4;
    public static final int ZOOM_OUT = 5;
    private static final StandardToolKind[] VALUES_ARRAY;
    public static final List<StandardToolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StandardToolKind[]{SELECT_LITERAL, SELECT_PAN_LITERAL, MARQUEE_LITERAL, ZOOM_PAN_LITERAL, ZOOM_IN_LITERAL, ZOOM_OUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StandardToolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StandardToolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StandardToolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StandardToolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StandardToolKind get(int value) {
        switch (value) {
            case 0: {
                return SELECT_LITERAL;
            }
            case 1: {
                return SELECT_PAN_LITERAL;
            }
            case 2: {
                return MARQUEE_LITERAL;
            }
            case 3: {
                return ZOOM_PAN_LITERAL;
            }
            case 4: {
                return ZOOM_IN_LITERAL;
            }
            case 5: {
                return ZOOM_OUT_LITERAL;
            }
        }
        return null;
    }

    private StandardToolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

