/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

public class AbstractChangeCompletionAction
extends Action {
    protected boolean shouldEnable(List<IRepositoryElement> selectedElements) {
        boolean allLocalTasks = true;
        for (IRepositoryElement abstractTaskContainer : selectedElements) {
            if (!(abstractTaskContainer instanceof ITask)) {
                allLocalTasks = false;
                break;
            }
            if (((AbstractTask)abstractTaskContainer).isLocal()) continue;
            allLocalTasks = false;
            break;
        }
        return allLocalTasks;
    }

    protected String generateMessage(List<AbstractTask> toComplete, String status) {
        String message = String.valueOf(MessageFormat.format(Messages.AbstractChangeCompletionAction_Mark_selected_local_tasks_X, status)) + "\n\n";
        int i = 0;
        for (ITask iTask : toComplete) {
            if (++i < 20) {
                message = String.valueOf(message) + "    ";
                if (iTask.getTaskKey() != null) {
                    message = String.valueOf(message) + iTask.getTaskKey() + ": ";
                }
                message = String.valueOf(message) + iTask.getSummary() + "\n";
                continue;
            }
            message = String.valueOf(message) + "...";
            break;
        }
        return message;
    }
}

