/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.SelectBranchPointDialog;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.ui.internal.compare.AbstractAction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.action.IAction;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergeAction
extends AbstractAction<CDOTransaction> {
    private final boolean allowTimeStamp;

    public MergeAction(boolean allowTimeStamp) {
        super(CDOTransaction.class);
        this.allowTimeStamp = allowTimeStamp;
    }

    @Override
    protected void run(IAction action, List<CDOTransaction> targets) {
        CDOTransaction leftView;
        CDOSession session;
        IWorkbenchPage page;
        SelectBranchPointDialog dialog;
        if (targets.size() == 1 && (dialog = new SelectBranchPointDialog(page = this.getTargetPart().getSite().getPage(), session = (leftView = targets.get(0)).getSession(), (CDOBranchPoint)leftView, this.allowTimeStamp)).open() == 0) {
            CDOView rightView = this.openView(session, dialog.getBranchPoint());
            CDOView[] originView = new CDOView[1];
            try {
                CDOCompareEditorUtil.openDialog((CDOView)leftView, rightView, originView);
            }
            finally {
                LifecycleUtil.deactivate((Object)originView[0]);
                if (!rightView.isDirty()) {
                    LifecycleUtil.deactivate((Object)rightView);
                }
            }
        }
    }

    private CDOView openView(CDOSession session, CDOBranchPoint branchPoint) {
        if (branchPoint.getTimeStamp() == 0L) {
            return session.openTransaction(branchPoint.getBranch());
        }
        return session.openView(branchPoint);
    }

    public static class FromBranch
    extends MergeAction {
        public FromBranch() {
            super(false);
        }
    }

    public static class FromBranchPoint
    extends MergeAction {
        public FromBranchPoint() {
            super(true);
        }
    }
}

