/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.IInvariantConfigurationModelCreation;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.InvariantRuleConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.InvariantSemanticTypeConfigurationPackage;
import org.eclipse.papyrus.infra.extendedtypes.invariantsemantictypeconfiguration.provider.InvariantSemanticTypeConfigurationItemProvider;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomInvariantSemanticTypeConfigurationItemProvider
extends InvariantSemanticTypeConfigurationItemProvider {
    protected Map<String, IInvariantConfigurationModelCreation<InvariantRuleConfiguration>> configurationToFactory = new HashMap<String, IInvariantConfigurationModelCreation<InvariantRuleConfiguration>>();

    public CustomInvariantSemanticTypeConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        this.addFromExtensionPoints(newChildDescriptors, object);
    }

    protected void addFromExtensionPoints(Collection<Object> newChildDescriptors, Object object) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.extendedtypes.invariantRule");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationModelCreationClassName = configurationElement.getAttribute("configurationModelCreation");
            if (configurationModelCreationClassName != null) {
                String contributorName = configurationElement.getContributor().getName();
                IInvariantConfigurationModelCreation<InvariantRuleConfiguration> configurationModelCreation = this.configurationToFactory.get(configurationModelCreationClassName);
                if (configurationModelCreation == null) {
                    Class<IInvariantConfigurationModelCreation<InvariantRuleConfiguration>> configurationClass = null;
                    try {
                        configurationClass = this.loadInvariantRulecModelCreationClass(configurationModelCreationClassName, contributorName);
                    }
                    catch (ClassNotFoundException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                    if (configurationClass != null) {
                        try {
                            configurationModelCreation = configurationClass.newInstance();
                            this.configurationToFactory.put(configurationModelCreationClassName, configurationModelCreation);
                        }
                        catch (InstantiationException e) {
                            Activator.log.error((Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                if (configurationModelCreation != null) {
                    newChildDescriptors.add(this.createChildParameter(InvariantSemanticTypeConfigurationPackage.eINSTANCE.getInvariantSemanticTypeConfiguration_InvariantRuleConfiguration(), configurationModelCreation.createConfigurationModel()));
                }
            }
            ++n2;
        }
    }

    protected Class<IInvariantConfigurationModelCreation<InvariantRuleConfiguration>> loadInvariantRulecModelCreationClass(String className, String bundleId) throws ClassNotFoundException {
        int state;
        Class found = null;
        Bundle bundle = CustomInvariantSemanticTypeConfigurationItemProvider.basicGetBundle(bundleId);
        if (bundle != null && ((state = bundle.getState()) == 32 || state == 8)) {
            found = bundle.loadClass(className);
            return found;
        }
        return null;
    }

    private static Bundle basicGetBundle(String bundleId) {
        return Platform.getBundle((String)bundleId);
    }
}

