/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class LockStateIndication
extends CDOServerReadIndication {
    private CDOLockState[] cdoLockStates;

    public LockStateIndication(CDOServerProtocol protocol) {
        super(protocol, (short)52);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        InternalView view = this.getSession().getView(viewID);
        if (view == null) {
            throw new IllegalStateException("View not found");
        }
        InternalLockManager lockMgr = this.getRepository().getLockingManager();
        int n = in.readInt();
        this.cdoLockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            Object key = this.indicatingCDOID(in, view.getBranch());
            RWOLockManager.LockState lockState = lockMgr.getLockState(key);
            this.cdoLockStates[i] = lockState != null ? CDOLockUtil.createLockState((RWOLockManager.LockState)lockState) : CDOLockUtil.createLockState((Object)key);
            ++i;
        }
    }

    private Object indicatingCDOID(CDODataInput in, CDOBranch viewedBranch) throws IOException {
        CDOID id = in.readCDOID();
        if (this.getRepository().isSupportingBranches()) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)viewedBranch);
        }
        return id;
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeInt(this.cdoLockStates.length);
        CDOLockState[] cDOLockStateArray = this.cdoLockStates;
        int n = this.cdoLockStates.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockState lockState = cDOLockStateArray[n2];
            out.writeCDOLockState(lockState);
            ++n2;
        }
    }
}

