/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.EValidatorRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectableValidator
implements EValidator {
    public static final String CURRENT_LANGUAGE_NAME = String.valueOf(AbstractInjectableValidator.class.getCanonicalName()) + ".currentLanguageName";
    public static final String ISSUE_SEVERITIES = String.valueOf(AbstractInjectableValidator.class.getCanonicalName()) + ".issueSeverities";
    @Inject
    @Named(value="languageName")
    private String languageName;

    @Inject
    public void register(EValidatorRegistrar registrar) {
        List<EPackage> packages = this.getEPackages();
        if (packages.size() == 0) {
            throw new IllegalStateException("No EPackages were registered for the validator " + this.getClass().getName() + " please override and implement getEPackages().");
        }
        for (EPackage ePackage : packages) {
            registrar.register(ePackage, this);
        }
    }

    protected List<EPackage> getEPackages() {
        throw new UnsupportedOperationException("please overwrite");
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public final boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public final boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.isResponsible(context, eObject) ? this.internalValidate(eObject.eClass(), eObject, diagnostics, context) : true;
    }

    protected abstract boolean internalValidate(EClass var1, EObject var2, DiagnosticChain var3, Map<Object, Object> var4);

    public boolean isLanguageSpecific() {
        return this.languageName != null;
    }

    protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        return !this.isLanguageSpecific() || Strings.equal((String)this.languageName, (String)this.getCurrentLanguage(context, eObject));
    }

    protected String getCurrentLanguage(Map<Object, Object> context, EObject eObject) {
        String currentLanguage;
        String string = currentLanguage = context != null ? (String)context.get(CURRENT_LANGUAGE_NAME) : null;
        if (currentLanguage == null) {
            Resource resource = eObject.eResource();
            currentLanguage = resource instanceof XtextResource ? ((XtextResource)resource).getLanguageName() : "";
            if (context != null) {
                context.put(CURRENT_LANGUAGE_NAME, currentLanguage);
            }
        }
        return currentLanguage;
    }
}

