/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;

public class SemanticNodeProvider
implements ISemanticNodeProvider {
    protected NodesForEObjectProvider createNodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
        return new NodesForEObjectProvider(semanticObject, node);
    }

    public ISemanticNodeProvider.INodesForEObjectProvider getNodesForSemanticObject(EObject semanticObject, ICompositeNode suggestedComposite) {
        if (suggestedComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, suggestedComposite);
        }
        ICompositeNode actualComposite = NodeModelUtils.findActualNodeFor(semanticObject);
        if (actualComposite != null) {
            return this.createNodesForEObjectProvider(semanticObject, actualComposite);
        }
        return ISemanticNodeProvider.NULL_NODES_PROVIDER;
    }

    public static class NodesForEObjectProvider
    implements ISemanticNodeProvider.INodesForEObjectProvider {
        protected final Object[] childrenByFeatureIDAndIndex;
        protected Map<EObject, INode> childrenBySemanticChild = null;
        protected final ICompositeNode node;
        protected final EObject semanticObject;

        public NodesForEObjectProvider(EObject semanticObject, ICompositeNode node) {
            this.semanticObject = semanticObject;
            this.node = node;
            this.childrenByFeatureIDAndIndex = new Object[semanticObject.eClass().getFeatureCount()];
            this.collectNodesForFeatures();
        }

        protected void add(String featureName, INode child) {
            EObject semanitcChild;
            EReference reference;
            if (featureName == null) {
                return;
            }
            EClass eClass = this.semanticObject.eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null) {
                return;
            }
            int id = eClass.getFeatureID(feature);
            if (feature.isMany()) {
                List nodes = (List)this.childrenByFeatureIDAndIndex[id];
                if (nodes == null) {
                    nodes = Lists.newArrayList();
                    this.childrenByFeatureIDAndIndex[id] = nodes;
                }
                nodes.add(child);
            } else {
                this.childrenByFeatureIDAndIndex[id] = child;
            }
            if (feature instanceof EReference && (reference = (EReference)feature).isContainment() && (semanitcChild = this.getSemanticChild(child)) != null) {
                if (this.childrenBySemanticChild == null) {
                    this.childrenBySemanticChild = Maps.newHashMap();
                }
                this.childrenBySemanticChild.put(semanitcChild, child);
            }
        }

        protected void collectNodesForFeatures() {
            BidiTreeIterator<INode> iterator = this.node.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                Assignment assignment;
                INode child = iterator.next();
                EObject grammarElement = child.getGrammarElement();
                if (grammarElement == null) continue;
                if (grammarElement instanceof Action) {
                    Action action = (Action)grammarElement;
                    if (child.getSemanticElement() == this.semanticObject) {
                        child = iterator.next();
                        this.add(action.getFeature(), child);
                    } else {
                        INode firstChild = ((ICompositeNode)child).getFirstChild();
                        while (firstChild.getGrammarElement() instanceof Action) {
                            firstChild = ((ICompositeNode)firstChild).getFirstChild();
                        }
                        EObject firstChildGrammarElement = firstChild.getGrammarElement();
                        Assignment assignment2 = GrammarUtil.containingAssignment(firstChildGrammarElement);
                        if (assignment2 != null) {
                            this.add(assignment2.getFeature(), child);
                        }
                    }
                    iterator.prune();
                    continue;
                }
                if (child == this.node || (assignment = GrammarUtil.containingAssignment(grammarElement)) == null) continue;
                this.add(assignment.getFeature(), child);
                iterator.prune();
            }
        }

        public INode getNodeForMultiValue(EStructuralFeature feat, int indexInFeat, int indexInNonTransient, Object val) {
            INode candiadate;
            if (this.childrenBySemanticChild != null && feat instanceof EReference && ((EReference)feat).isContainment() && (candiadate = this.childrenBySemanticChild.get(val)) != null) {
                return candiadate;
            }
            Object object = this.childrenByFeatureIDAndIndex[this.semanticObject.eClass().getFeatureID(feat)];
            if (feat.isMany() && object instanceof List) {
                List nodes = (List)object;
                if (indexInNonTransient >= 0 && indexInNonTransient < nodes.size()) {
                    return (INode)nodes.get(indexInNonTransient);
                }
            } else if (object instanceof INode) {
                return (INode)object;
            }
            return null;
        }

        public INode getNodeForSingelValue(EStructuralFeature feature, Object value) {
            return this.getNodeForMultiValue(feature, 0, 0, value);
        }

        protected EObject getSemanticChild(INode node) {
            EObject root = node.getSemanticElement();
            if (root != null && root != this.semanticObject) {
                return root;
            }
            BidiTreeIterator<INode> iterator = node.getAsTreeIterable().iterator();
            while (iterator.hasNext()) {
                EObject candidate = iterator.next().getSemanticElement();
                if (candidate == null || candidate == this.semanticObject) continue;
                return candidate;
            }
            return null;
        }
    }
}

