/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.scoping.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadOnDemandResourceDescriptions
extends AbstractCompoundSelectable
implements IResourceDescriptions {
    private IResourceDescriptions delegate;
    private Collection<URI> validUris;
    private Resource context;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    public void initialize(IResourceDescriptions delegate, Collection<URI> validUris, Resource context) {
        this.delegate = delegate;
        this.validUris = validUris;
        this.context = context;
    }

    @Override
    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return Iterables.filter((Iterable)Iterables.transform(this.validUris, (Function)new Function<URI, IResourceDescription>(){

            public IResourceDescription apply(URI from) {
                return LoadOnDemandResourceDescriptions.this.getResourceDescription(from);
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    public boolean isEmpty() {
        return this.validUris.isEmpty();
    }

    @Override
    protected Iterable<? extends ISelectable> getSelectables() {
        return this.getAllResourceDescriptions();
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        Resource resource;
        IResourceDescription result = this.delegate.getResourceDescription(uri);
        if (result == null && (resource = EcoreUtil2.getResource(this.context, uri.toString())) != null) {
            IResourceServiceProvider serviceProvider = this.serviceProviderRegistry.getResourceServiceProvider(uri);
            if (serviceProvider == null) {
                throw new IllegalStateException("No " + IResourceServiceProvider.class.getSimpleName() + " found in registry for uri " + uri);
            }
            IResourceDescription.Manager resourceDescriptionManager = serviceProvider.getResourceDescriptionManager();
            if (resourceDescriptionManager == null) {
                throw new IllegalStateException("No " + IResourceDescription.Manager.class.getName() + " provided by service provider for URI " + uri);
            }
            result = resourceDescriptionManager.getResourceDescription(resource);
        }
        return result;
    }
}

